/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.map.client.elements.geo.model.ui.actions;

import com.centreon.studio.client.model.LatLng;
import com.centreon.studio.client.model.Pos;
import com.centreon.studio.client.model.node.INode;
import com.centreon.studio.client.model.object.IObject;
import com.centreon.studio.client.model.properties.PropertyDescriptor;
import com.centreon.studio.client.model.property.PropertyDescriptors;
import com.centreon.studio.client.model.relation.INodeRelation;
import com.centreon.studio.client.model.repository.IRepository;
import com.centreon.studio.client.model.ui.actions.common.IUndoHandler;
import com.centreon.studio.client.model.ui.actions.common.PropertiesUndoHandler;
import com.centreon.studio.client.model.ui.actions.edit.AACLRepositoryAction;
import com.centreon.studio.map.client.elements.geo.model.GeoPropertyDescriptors;
import com.centreon.studio.map.client.elements.geo.providers.MapBoxProvider;

public class GeoPanningAction
extends AACLRepositoryAction {
    private final Pos delta;

    public GeoPanningAction(IRepository input, Pos delta) {
        super(null, input);
        this.delta = delta;
        this.setSelectionSingleAccepted(true);
    }

    protected IUndoHandler internalRun() {
        INodeRelation relation = this.getInput().getSelection();
        INode target = relation.getTarget();
        Double zoom = (Double)target.getProperty(PropertyDescriptors.CURRENT_ZOOM);
        LatLng center = (LatLng)relation.getProperty(GeoPropertyDescriptors.CURRENT_LATLNG);
        Pos centerPos = MapBoxProvider.latLngToPoint(center, zoom.intValue(), center);
        Pos newCenterPos = centerPos.minus(this.delta);
        LatLng newLatLng = MapBoxProvider.pointToLatLng(newCenterPos, zoom.intValue(), center);
        PropertiesUndoHandler undo = new PropertiesUndoHandler((IObject)relation, new PropertyDescriptor[]{GeoPropertyDescriptors.CURRENT_LATLNG});
        relation.addPropertyValue(GeoPropertyDescriptors.CURRENT_LATLNG, (Object)newLatLng);
        return undo;
    }
}

