/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.map.client.elements.geo.providers;

import com.centreon.studio.client.acl.ACLUser;
import com.centreon.studio.client.commons.swt.SWTUtils;
import com.centreon.studio.client.events.BrokerEventManager;
import com.centreon.studio.client.events.StudioEvent;
import com.centreon.studio.client.events.StudioEventHandler;
import com.centreon.studio.client.events.auth.AuthenticationEventHandler;
import com.centreon.studio.client.events.exception.ExceptionEvent;
import com.centreon.studio.client.events.log.LogEvent;
import com.centreon.studio.client.model.LatLng;
import com.centreon.studio.client.model.Pos;
import com.centreon.studio.client.utils.StepTimeTracker;
import com.centreon.studio.client.utils.StringUtils;
import com.centreon.studio.map.client.elements.geo.messages.GeoMessages;
import com.centreon.studio.map.client.elements.geo.model.GeoPropertyDescriptors;
import com.centreon.studio.map.client.elements.geo.tiles.StyleDescription;
import com.centreon.studio.map.client.elements.geo.tiles.TileDescription;
import com.eclipsesource.json.Json;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

@Creatable
@Singleton
public class MapBoxProvider {
    public static final int TILE_SIZE = 512;
    private static final double[] ZOOM_LEVELS = new double[]{1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 11.0, 12.0, 13.0, 14.0, 15.0, 16.0, 17.0, 18.0, 19.0, 20.0};
    private static final double PX_PER_LON_RAD = 81.48733086305042;
    private static final double PX_PER_LON_DEG = 1.4222222222222223;
    private static final Pos PX_ORIGIN = Pos.create((double)256.0, (double)256.0);
    private static final String ERROR_IMAGE_PATH = "platform:/plugin/com.centreon.studio.map.client.elements.geo/img/error.png";
    private static final String URL_PREFIX = "https://api.mapbox.com/styles/v1/";
    private static final String URL_SUFFIX = "?access_token=";
    private static final String MAPBOX = "mapbox";
    private static final String TILES = "tiles";
    private static final StepTimeTracker COUNTER = new StepTimeTracker();
    public static final StyleDescription DEFAULT_STYLE = new StyleDescription("light-v9", "Mapbox Light", "mapbox");
    private static final Collection<StyleDescription> DEFAULT_STYLES = new ArrayList<StyleDescription>(6);
    private final AuthenticationEventHandler authenticationEventHandler;
    private final Map<TileDescription, Image> cache = new HashMap<TileDescription, Image>(128);
    private final Collection<StyleDescription> styles = new ArrayList<StyleDescription>(12);
    private final BrokerEventManager eventManager;
    private ACLUser user;

    static {
        DEFAULT_STYLES.add(DEFAULT_STYLE);
        DEFAULT_STYLES.add(new StyleDescription("dark-v9", "Mapbox Dark", MAPBOX));
        DEFAULT_STYLES.add(new StyleDescription("streets-v9", "Mapbox Streets", MAPBOX));
        DEFAULT_STYLES.add(new StyleDescription("outdoors-v9", "Mapbox Outdoors", MAPBOX));
        DEFAULT_STYLES.add(new StyleDescription("satellite-v9", "Mapbox Satellite", MAPBOX));
        DEFAULT_STYLES.add(new StyleDescription("satellite-streets-v9", "Mapbox Satellite Streets", MAPBOX));
    }

    public static double getMaxZoom() {
        return ZOOM_LEVELS[ZOOM_LEVELS.length - 1];
    }

    public static double getMinZoom() {
        return ZOOM_LEVELS[0];
    }

    public static double[] getZoomLevels() {
        return Arrays.copyOf(ZOOM_LEVELS, ZOOM_LEVELS.length);
    }

    public static Pos latLngToPoint(LatLng latLng, int zoom, LatLng center) {
        Pos centerPos = MapBoxProvider.toPoint(center, zoom);
        Pos pos = MapBoxProvider.toPoint(latLng, zoom);
        return pos.minus(centerPos);
    }

    public static LatLng pointToLatLng(Pos pos, int zoom, LatLng center) {
        Pos centerPos = MapBoxProvider.toPoint(center, zoom);
        return MapBoxProvider.toLatLng(centerPos.plus(pos), zoom);
    }

    public static Pos toPoint(LatLng latLng, int zoom) {
        double x = MapBoxProvider.PX_ORIGIN.x + latLng.x * 1.4222222222222223;
        double siny = MapBoxProvider.bound(Math.sin(MapBoxProvider.degreesToRadians(latLng.y)), -0.9999, 0.9999);
        double y = MapBoxProvider.PX_ORIGIN.y + 0.5 * Math.log((1.0 + siny) / (1.0 - siny)) * -81.48733086305042;
        int numTiles = 1 << zoom;
        return Pos.create((double)(x * (double)numTiles), (double)(y * (double)numTiles));
    }

    private static double bound(double val, double min, double max) {
        return Math.min(Math.max(val, min), max);
    }

    private static double degreesToRadians(double deg) {
        return deg * (Math.PI / 180);
    }

    private static double radiansToDegrees(double rad) {
        return rad / (Math.PI / 180);
    }

    private static LatLng toLatLng(Pos point, int zoom) {
        int numTiles = 1 << zoom;
        double x = point.x / (double)numTiles;
        double y = point.y / (double)numTiles;
        double lng = (x - MapBoxProvider.PX_ORIGIN.x) / 1.4222222222222223;
        double latRadians = (y - MapBoxProvider.PX_ORIGIN.y) / -81.48733086305042;
        double lat = MapBoxProvider.radiansToDegrees(2.0 * Math.atan(Math.exp(latRadians)) - 1.5707963267948966);
        return LatLng.create((double)lat, (double)lng);
    }

    @Inject
    public MapBoxProvider(BrokerEventManager eventManager) {
        this.eventManager = eventManager;
        this.authenticationEventHandler = new AuthenticationEventHandler(){

            protected void loggedOut() {
                MapBoxProvider.this.cache.clear();
                MapBoxProvider.this.styles.clear();
            }
        };
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Collection<StyleDescription> getStyles() {
        token = (String)this.user.getProperty(GeoPropertyDescriptors.MAPBOX_TOKEN);
        if (StringUtils.isNullEmptyOrBlank((String)token)) {
            return Collections.emptyList();
        }
        if (!this.styles.isEmpty()) {
            return this.styles;
        }
        this.styles.addAll(MapBoxProvider.DEFAULT_STYLES);
        map = (String)this.user.getProperty(GeoPropertyDescriptors.MAPBOX_MAP);
        end = map.contains(".") != false ? map.lastIndexOf(".") : map.length();
        username = map.substring(0, end);
        if (StringUtils.isNullEmptyOrBlank((String)username)) {
            return this.styles;
        }
        builder = new StringBuilder();
        builder.append("https://api.mapbox.com/styles/v1/");
        builder.append(username);
        builder.append("?access_token=");
        builder.append(token);
        try {
            stringUrl = builder.toString();
            url = new URL(stringUrl);
            HttpURLConnection.setFollowRedirects(true);
            connection = (HttpURLConnection)url.openConnection();
            connection.setInstanceFollowRedirects(true);
            connection.setConnectTimeout(10000);
            connection.setReadTimeout(10000);
            var9_10 = null;
            var10_12 = null;
            try {
                is = connection.getInputStream();
                try {
                    block28: {
                        isr = new InputStreamReader(is, "UTF-8");
                        try {
                            block27: {
                                br = new BufferedReader(isr);
                                try {
                                    object = Json.parse((Reader)br).asArray();
                                    var16_20 = object.iterator();
                                    while (true) {
                                        if (!var16_20.hasNext()) {
                                            v0 = this.styles;
                                            return v0;
                                        }
                                        jv = (JsonValue)var16_20.next();
                                        id = ((JsonObject)jv).get("id").asString();
                                        name = ((JsonObject)jv).get("name").asString();
                                        owner = ((JsonObject)jv).get("owner").asString();
                                        this.styles.add(new StyleDescription(id, name, owner));
                                    }
                                }
                                finally {
                                    if (br == null) break block27;
                                    br.close();
                                }
                            }
                            if (isr == null) break block28;
                        }
                        catch (Throwable var10_13) {
                            if (var9_10 == null) {
                                var9_10 = var10_13;
                            } else if (var9_10 != var10_13) {
                                var9_10.addSuppressed(var10_13);
                            }
                            if (isr == null) throw var9_10;
                            isr.close();
                            throw var9_10;
                        }
                        isr.close();
                    }
                    if (is != null) {
                    }
                    ** GOTO lbl-1000
                }
                catch (Throwable var10_14) {
                    if (var9_10 == null) {
                        var9_10 = var10_14;
                    } else if (var9_10 != var10_14) {
                        var9_10.addSuppressed(var10_14);
                    }
                    if (is == null) throw var9_10;
                    is.close();
                    throw var9_10;
                }
                is.close();
lbl-1000:
                // 2 sources

                {
                    return v0;
                }
            }
            catch (Throwable var10_15) {
                if (var9_10 == null) {
                    var9_10 = var10_15;
                    throw var9_10;
                }
                if (var9_10 == var10_15) throw var9_10;
                var9_10.addSuppressed(var10_15);
                throw var9_10;
            }
        }
        catch (Exception e) {
            this.eventManager.async((StudioEvent)new ExceptionEvent((Throwable)e));
            return this.styles;
        }
    }

    public Image getTile(TileDescription tile) {
        StepTimeTracker counter = new StepTimeTracker("MapBoxProvider.getTile() " + tile);
        Image image = this.cache.get(tile);
        if (image != null) {
            return image;
        }
        String token = (String)this.user.getProperty(GeoPropertyDescriptors.MAPBOX_TOKEN);
        if (StringUtils.isOneNullEmptyOrBlank((String[])new String[]{token}) || tile.style == null) {
            this.eventManager.async((StudioEvent)LogEvent.error(MapBoxProvider.class, (String)"MapBox token and/or style is empty", (Object[])new Object[0]));
            return SWTUtils.getImageFromUrl((String)ERROR_IMAGE_PATH, (int)512, (int)512);
        }
        StringBuilder builder = new StringBuilder();
        builder.append(URL_PREFIX);
        builder.append(tile.style.owner);
        builder.append("/");
        builder.append(tile.style.id);
        builder.append("/");
        builder.append(TILES);
        builder.append("/");
        builder.append(tile.z);
        builder.append("/");
        builder.append(tile.getActualX());
        builder.append("/");
        builder.append(tile.getActualY());
        builder.append(URL_SUFFIX);
        builder.append(token);
        String stringUrl = builder.toString();
        try {
            Image image2;
            block17: {
                COUNTER.step("start");
                URL url = new URL(stringUrl);
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setConnectTimeout(5000);
                connection.setReadTimeout(15000);
                Throwable throwable = null;
                Object var10_12 = null;
                InputStream is = connection.getInputStream();
                try {
                    image = new Image((Device)Display.getCurrent(), is);
                    this.cache.put(tile, image);
                    this.cleanCache();
                    image2 = image;
                    if (is == null) break block17;
                }
                catch (Throwable throwable2) {
                    try {
                        if (is != null) {
                            is.close();
                        }
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        try {
                            if (throwable == null) {
                                throwable = throwable3;
                            } else if (throwable != throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            throw throwable;
                        }
                        catch (Exception e) {
                            this.eventManager.async((StudioEvent)new ExceptionEvent((Throwable)new Exception(GeoMessages.mapboxTileError, e)));
                            image2 = SWTUtils.getImageFromUrl((String)ERROR_IMAGE_PATH, (int)512, (int)512);
                            counter.step(" from url " + stringUrl);
                            COUNTER.step("stop");
                            return image2;
                        }
                    }
                }
                is.close();
            }
            counter.step(" from url " + stringUrl);
            COUNTER.step("stop");
            return image2;
        }
        catch (Throwable throwable) {
            counter.step(" from url " + stringUrl);
            COUNTER.step("stop");
            throw throwable;
        }
    }

    @PostConstruct
    public void postConstruct(BrokerEventManager eventManager) {
        eventManager.subscribe("studio/authentication", false, (StudioEventHandler)this.authenticationEventHandler);
    }

    @PreDestroy
    public void preDestroy(BrokerEventManager eventManager) {
        eventManager.unsubscribe((StudioEventHandler)this.authenticationEventHandler);
    }

    @Inject
    public void setUser(@Optional ACLUser user) {
        this.user = user;
        this.getStyles();
    }

    private void cleanCache() {
    }
}

