/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.map.client.elements.geo.tiles;

import com.centreon.studio.client.model.Pos;
import com.centreon.studio.map.client.elements.geo.providers.MapBoxProvider;
import com.centreon.studio.map.client.elements.geo.tiles.StyleDescription;

public class TileDescription {
    public final int x;
    public final int y;
    public final int z;
    private final int max;
    public final Pos pos;
    public final StyleDescription style;

    public TileDescription(int z, int x, int y) {
        this(z, x, y, null);
    }

    public TileDescription(int z, int x, int y, StyleDescription style) {
        this.z = (int)Math.min(MapBoxProvider.getMaxZoom(), Math.max(MapBoxProvider.getMinZoom(), (double)z));
        this.max = (int)Math.pow(2.0, this.z);
        this.x = x;
        this.y = y;
        this.pos = Pos.create((double)(this.x * 512), (double)(this.y * 512));
        this.style = style;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TileDescription other = (TileDescription)obj;
        if (this.style == null ? other.style != null : !this.style.equals(other.style)) {
            return false;
        }
        if (this.x != other.x) {
            return false;
        }
        if (this.y != other.y) {
            return false;
        }
        return this.z == other.z;
    }

    public int getActualX() {
        int actual = this.x % this.max;
        if (actual < 0) {
            actual += this.max;
        }
        return actual;
    }

    public int getActualY() {
        int actual = this.y % this.max;
        if (actual < 0) {
            actual += this.max;
        }
        return actual;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.style == null ? 0 : this.style.hashCode());
        result = 31 * result + this.x;
        result = 31 * result + this.y;
        result = 31 * result + this.z;
        return result;
    }

    public String toString() {
        return "Tile " + this.z + "/" + this.x + "/" + this.y;
    }
}

