/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.model.decoration.node;

import com.centreon.studio.client.model.decoration.object.ObjectDecorator;
import com.centreon.studio.client.model.decoration.relation.RelationDecorator;
import com.centreon.studio.client.model.decoration.repository.IRepositoryStrategy;
import com.centreon.studio.client.model.decoration.repository.RepositoryDecorator;
import com.centreon.studio.client.model.node.INode;
import com.centreon.studio.client.model.node.INodeRelationListener;
import com.centreon.studio.client.model.object.IObject;
import com.centreon.studio.client.model.object.TypeDescriptor;
import com.centreon.studio.client.model.relation.INodeRelation;
import com.centreon.studio.client.utils.CollectionsUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.core.runtime.Assert;

public class NodeDecorator
extends ObjectDecorator
implements INode,
INodeRelationListener {
    private Map<TypeDescriptor, List<INodeRelation>> relations;
    private Collection<INodeRelationListener> listeners;

    protected static final Collection<INodeRelation> undecorate(Collection<? extends INodeRelation> relations) {
        if (relations == null) {
            return Collections.emptyList();
        }
        ArrayList<INodeRelation> undecorated = new ArrayList<INodeRelation>(relations.size());
        for (INodeRelation iNodeRelation : relations) {
            if (iNodeRelation == null) continue;
            undecorated.add((INodeRelation)iNodeRelation.adapt(INodeRelation.class));
        }
        return undecorated;
    }

    public NodeDecorator(INode node, RepositoryDecorator repository) {
        super((IObject)node, repository);
        this.init();
    }

    @Override
    public <A> A adapt(Class<A> clazz) {
        A a = super.adapt(clazz);
        if (a != null) {
            return a;
        }
        for (IRepositoryStrategy strategy : this.getRepository().getStrategies()) {
            if (!clazz.isAssignableFrom(strategy.getClass())) continue;
            return (A)strategy;
        }
        return null;
    }

    public final INodeRelation addRelation(INodeRelation relation) {
        Collection<INodeRelation> collection;
        if (relation != null && (collection = this.addRelations(Arrays.asList(relation))) != null && !collection.isEmpty()) {
            return collection.iterator().next();
        }
        return null;
    }

    public final Collection<INodeRelation> addRelations(Collection<INodeRelation> relations) {
        if (relations == null || relations.isEmpty()) {
            return Collections.emptyList();
        }
        Collection<INodeRelation> undecoratedRelations = NodeDecorator.undecorate(relations);
        for (IRepositoryStrategy strategy : this.getRepository().getStrategies()) {
            strategy.addRelations(this, undecoratedRelations);
        }
        return this.getDecorated().addRelations(undecoratedRelations);
    }

    public Map<TypeDescriptor, List<INodeRelation>> getInternalRelations() {
        return this.relations != null ? this.relations : Collections.emptyMap();
    }

    public List<INodeRelation> getRelations(TypeDescriptor ... descriptors) {
        if (this.relations == null) {
            return Collections.emptyList();
        }
        ArrayList<INodeRelation> allRelations = new ArrayList<INodeRelation>(0);
        if (descriptors == null || descriptors.length == 0) {
            for (Collection collection : this.relations.values()) {
                allRelations.addAll(collection);
            }
        } else {
            TypeDescriptor[] typeDescriptorArray = descriptors;
            int n = descriptors.length;
            int n2 = 0;
            while (n2 < n) {
                TypeDescriptor typeDescriptor = typeDescriptorArray[n2];
                allRelations.addAll((Collection<INodeRelation>)this.relations.get(typeDescriptor));
                ++n2;
            }
        }
        return allRelations;
    }

    public void registerRelationsListener(INodeRelationListener nodeListener) {
        if (nodeListener == null) {
            return;
        }
        if (this.listeners == null) {
            this.listeners = new CopyOnWriteArrayList<INodeRelationListener>();
        }
        this.listeners.add(nodeListener);
    }

    public final void relationsAdded(INode node, Collection<INodeRelation> relations) {
        Collection<INodeRelation> decoratedRelations = this.decorate(relations);
        for (IRepositoryStrategy strategy : this.getRepository().getStrategies()) {
            strategy.relationsAdded(this, decoratedRelations);
        }
        this.sendAddedEvent(decoratedRelations);
    }

    public final void relationsRemoved(INode node, Collection<INodeRelation> relations) {
        ArrayList<INodeRelation> actualRelations = new ArrayList<INodeRelation>(relations);
        for (IRepositoryStrategy strategy : this.getRepository().getStrategies()) {
            strategy.relationsRemoved(this, actualRelations);
        }
        if (this.relations != null) {
            Iterator it = actualRelations.iterator();
            while (it.hasNext()) {
                INodeRelation relation = (INodeRelation)it.next();
                Assert.isTrue((boolean)relation.getSource().equals((Object)this), (String)"decorated source must equals this");
                Collection typedRelations = this.relations.get(relation.getType());
                if (!typedRelations.remove(relation)) {
                    it.remove();
                }
                if (!typedRelations.isEmpty()) continue;
                this.relations.remove(relation.getType());
            }
        }
        this.sendRemovedEvent(actualRelations);
    }

    public void removeRelation(INodeRelation relation) {
        if (relation != null) {
            this.removeRelations(Arrays.asList(relation));
        }
    }

    public final void removeRelations(Collection<INodeRelation> relations) {
        if (relations == null || relations.isEmpty()) {
            return;
        }
        Collection<INodeRelation> undecoratedRelations = NodeDecorator.undecorate(relations);
        for (IRepositoryStrategy strategy : this.getRepository().getStrategies()) {
            strategy.removeRelations(this, undecoratedRelations);
        }
        this.getDecorated().removeRelations(undecoratedRelations);
    }

    public void sendAddedEvent(Collection<INodeRelation> relations) {
        if (this.listeners != null && !relations.isEmpty()) {
            for (INodeRelationListener listener : this.listeners) {
                listener.relationsAdded((INode)this, relations);
            }
        }
    }

    public void sendRemovedEvent(Collection<INodeRelation> relations) {
        if (this.listeners != null && !relations.isEmpty()) {
            for (INodeRelationListener listener : this.listeners) {
                listener.relationsRemoved((INode)this, relations);
            }
        }
    }

    public void unregisterRelationsListener(INodeRelationListener nodeListener) {
        if (this.listeners == null || nodeListener == null) {
            return;
        }
        this.listeners.remove(nodeListener);
        if (this.listeners.isEmpty()) {
            this.listeners = null;
        }
    }

    protected INode getDecorated() {
        return (INode)super.getDecorated();
    }

    protected void init() {
        if (this.getRepository().getStrategies() == null) {
            return;
        }
        List decoratedRelations = this.getDecorated().getRelations(new TypeDescriptor[0]);
        if (!decoratedRelations.isEmpty()) {
            this.relationsAdded(this.getDecorated(), decoratedRelations);
        }
        this.getDecorated().registerRelationsListener((INodeRelationListener)this);
    }

    private Collection<INodeRelation> decorate(Collection<INodeRelation> relations) {
        if (relations == null || relations == Collections.EMPTY_LIST) {
            return Collections.emptyList();
        }
        if (this.relations == null) {
            this.relations = CollectionsUtils.createMap((int)1, Collections.emptyList());
        }
        ArrayList<INodeRelation> decoratedRelations = new ArrayList<INodeRelation>(relations.size());
        for (INodeRelation relation : relations) {
            if (relation == null) continue;
            NodeDecorator decoratedTarget = new NodeDecorator(relation.getTarget(), this.getRepository());
            RelationDecorator decoratedRelation = new RelationDecorator(relation, this, decoratedTarget);
            List typedRelations = this.relations.get(relation.getType());
            if (typedRelations == Collections.EMPTY_LIST) {
                typedRelations = CollectionsUtils.createList((int)1);
                this.relations.put(relation.getType(), typedRelations);
            }
            typedRelations.add(decoratedRelation);
            decoratedRelations.add(decoratedRelation);
        }
        return decoratedRelations;
    }
}

