/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.acl.ui;

import com.centreon.studio.client.acl.ACLPropertyDescriptors;
import com.centreon.studio.client.acl.ACLRepositoryDecorator;
import com.centreon.studio.client.acl.ACLTypes;
import com.centreon.studio.client.acl.messages.ACLMessages;
import com.centreon.studio.client.acl.ui.MultipleCheckboxComposite;
import com.centreon.studio.client.commons.swt.SWTUtils;
import com.centreon.studio.client.model.node.INode;
import com.centreon.studio.client.model.node.INodeUtils;
import com.centreon.studio.client.model.node.NodeFactories;
import com.centreon.studio.client.model.object.TypeDescriptor;
import com.centreon.studio.client.model.properties.PropertyDescriptor;
import com.centreon.studio.client.model.properties.PropertyValue;
import com.centreon.studio.client.model.relation.INodeRelation;
import com.centreon.studio.client.model.relation.NodeRelationFactories;
import com.centreon.studio.client.model.ui.messages.ModelUiMessages;
import com.centreon.studio.client.preference.ui.pages.APreferencePage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import javax.inject.Inject;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;

public class AdminACLPreferencePage
extends APreferencePage {
    private final ACLRepositoryDecorator repository;
    private final Collection<MultipleCheckboxComposite> checkboxs = new LinkedList<MultipleCheckboxComposite>();
    private Composite composite;

    @Inject
    public AdminACLPreferencePage(ACLRepositoryDecorator repository) {
        super(ACLMessages.keywordAdmin);
        this.repository = repository;
    }

    public boolean performOk() {
        this.performApply();
        return super.performOk();
    }

    protected void createHeadContents(Composite parent) {
        this.composite = SWTUtils.createComposite((Composite)parent, (int)2, (boolean)false);
        this.createFilter(this.composite, 2, ACLTypes.ACL_GROUP.getLabel());
        SWTUtils.createSpanner((Composite)this.composite, (int)2, (int)1);
        SWTUtils.createSpanner((Composite)this.composite, (int)1, (int)1);
        SWTUtils.createLabel((Composite)this.composite, (String)ACLMessages.centreonStudioAdmin, (int)0x1000000, (int)0x1000000, (int)-1, (int)-1);
        SWTUtils.createSpanner((Composite)this.composite, (int)2, (int)1);
        SWTUtils.createLabel((Composite)this.composite, (String)ModelUiMessages.keywordSelectAll, (int)4, (int)0x1000000, (int)-1, (int)-1);
        Button selectAll = SWTUtils.createButton((Composite)this.composite, (int)32, (String)"", (GridData)SWTUtils.createGridData((int)0x1000000, (int)0x1000000, (int)-1, (int)-1), null);
        SWTUtils.createSpanner((Composite)this.composite, (int)2, (int)1);
        for (INodeRelation relation : this.repository.getRelations(new TypeDescriptor[]{ACLTypes.ACL_GROUP})) {
            INode aclGroup = relation.getTarget();
            MultipleCheckboxComposite checkbox = new MultipleCheckboxComposite(aclGroup.getLabel(), -1L, ACLTypes.ADMIN, Arrays.asList(ACLPropertyDescriptors.CAN_READ));
            checkbox.fillComposite(this.composite);
            checkbox.setAclGroup(aclGroup);
            checkbox.addListenner(selectAll, (PropertyDescriptor<Boolean>)ACLPropertyDescriptors.CAN_READ);
            this.checkboxs.add(checkbox);
        }
        SWTUtils.createSpanner((Composite)this.composite, (int)2, (int)1);
        this.doFilter();
    }

    protected void doFilter() {
        this.checkboxs.stream().forEach(c -> c.setVisible(c.getLabel().toLowerCase().contains(this.filter.getText().toLowerCase())));
        this.composite.layout();
    }

    protected void performApply() {
        for (MultipleCheckboxComposite checkbox : this.checkboxs) {
            INode aclGroup = checkbox.getAclGroup();
            INodeRelation adminAclRuleRelation = INodeUtils.findRelationForTarget((INode)aclGroup, (TypeDescriptor)ACLTypes.ADMIN, (Long)-1L, (PropertyValue[])new PropertyValue[0]);
            INode adminAclRule = adminAclRuleRelation != null ? adminAclRuleRelation.getTarget() : null;
            boolean isAdmin = checkbox.getResults().get(aclGroup).get(ACLPropertyDescriptors.CAN_READ);
            if (isAdmin && adminAclRule == null) {
                ArrayList<PropertyValue> properties = new ArrayList<PropertyValue>(1);
                properties.add(new PropertyValue(ACLPropertyDescriptors.ACL_GROUP_ID, (Object)aclGroup.getId()));
                adminAclRule = NodeFactories.INSTANCE.create(ACLTypes.ADMIN, Long.valueOf(-1L), properties, aclGroup.getRepository());
                aclGroup.addRelation(NodeRelationFactories.INSTANCE.create(adminAclRule.getType(), adminAclRule.getId(), aclGroup, adminAclRule));
                continue;
            }
            if (isAdmin || adminAclRule == null) continue;
            aclGroup.removeRelation(adminAclRuleRelation);
        }
    }
}

