/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.sound;

import com.centreon.studio.client.commons.jface.dialogs.MessageDialogUtils;
import java.net.URL;
import javax.media.ControllerEvent;
import javax.media.ControllerListener;
import javax.media.EndOfMediaEvent;
import javax.media.Manager;
import javax.media.Player;
import javax.media.ResourceUnavailableEvent;
import javax.media.StopByRequestEvent;

public final class SoundPlayer
extends Thread {
    private URL url;
    private boolean playing;

    public SoundPlayer(URL url) {
        this.url = url;
    }

    public synchronized boolean isCurrentlyPlaying() {
        return this.playing;
    }

    @Override
    public void run() {
        try {
            this.setPlaying(true);
            final Player player = Manager.createPlayer((URL)this.url);
            player.addControllerListener(new ControllerListener(){

                public void controllerUpdate(ControllerEvent event) {
                    if (event instanceof EndOfMediaEvent || event instanceof StopByRequestEvent || event instanceof ResourceUnavailableEvent) {
                        player.close();
                        SoundPlayer.this.setPlaying(false);
                    }
                }
            });
            player.start();
        }
        catch (Exception e) {
            e.printStackTrace();
            MessageDialogUtils.openError((String)e.getMessage());
        }
    }

    public void setURL(URL url) {
        this.url = url;
    }

    private synchronized void setPlaying(boolean playing) {
        this.playing = playing;
    }
}

