/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.acl;

import com.centreon.studio.client.acl.ACLPropertyDescriptors;
import com.centreon.studio.client.acl.ACLTypes;
import com.centreon.studio.client.acl.ACLUtils;
import com.centreon.studio.client.events.BrokerEventManager;
import com.centreon.studio.client.events.StudioEvent;
import com.centreon.studio.client.events.sync.SyncEvent;
import com.centreon.studio.client.model.decoration.node.NodeDecorator;
import com.centreon.studio.client.model.decoration.object.ObjectDecorator;
import com.centreon.studio.client.model.decoration.repository.ARepositoryStrategy;
import com.centreon.studio.client.model.node.INode;
import com.centreon.studio.client.model.object.TypeDescriptor;
import com.centreon.studio.client.model.properties.PropertyValue;
import com.centreon.studio.client.model.relation.INodeRelation;
import java.util.Collection;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class ACLInternalRepositoryStrategy
extends ARepositoryStrategy {
    private final BrokerEventManager eventManager;
    private final ACLUtils aclUtils;

    private static boolean containsReadProperty(Collection<PropertyValue> propertyValues) {
        for (PropertyValue prop : propertyValues) {
            if (prop.getProperty() != ACLPropertyDescriptors.CAN_READ) continue;
            return true;
        }
        return false;
    }

    @Inject
    public ACLInternalRepositoryStrategy(BrokerEventManager eventManager, ACLUtils aclUtils) {
        this.eventManager = eventManager;
        this.aclUtils = aclUtils;
    }

    public void propertiesChanged(ObjectDecorator decorator, Collection<PropertyValue> propertyValues) {
        if (!ACLInternalRepositoryStrategy.containsReadProperty(propertyValues)) {
            return;
        }
        INode node = (INode)decorator.adapt(INode.class);
        if (node == null || node.getType() == ACLTypes.ACL_GROUP) {
            return;
        }
        if (Boolean.TRUE.equals(decorator.getProperty(ACLPropertyDescriptors.CAN_READ))) {
            this.readRightGained(node);
        } else {
            this.readRightLost(node);
        }
    }

    private void readRightGained(INode aclRule) {
        if (aclRule.getType() == ACLTypes.ADMIN) {
            for (TypeDescriptor type : this.aclUtils.getTypesUnderACL()) {
                this.eventManager.async((StudioEvent)new SyncEvent(SyncEvent.SyncAction.CREATE, type.getId(), Long.valueOf(-1L)));
            }
        } else {
            this.eventManager.async((StudioEvent)new SyncEvent(SyncEvent.SyncAction.CREATE, aclRule.getType().getId(), aclRule.getId()));
        }
    }

    private void readRightLost(INode aclRule) {
        if (aclRule.getType() == ACLTypes.ADMIN) {
            for (TypeDescriptor type : this.aclUtils.getTypesUnderACL()) {
                this.eventManager.async((StudioEvent)new SyncEvent(SyncEvent.SyncAction.REMOVE, type.getId(), Long.valueOf(-1L)));
            }
        } else if (!this.aclUtils.can(ACLPropertyDescriptors.CAN_READ, aclRule.getType(), aclRule.getId(), true).booleanValue()) {
            this.eventManager.async((StudioEvent)new SyncEvent(SyncEvent.SyncAction.REMOVE, aclRule.getType().getId(), aclRule.getId()));
        }
    }

    public void relationsAdded(NodeDecorator decorator, Collection<INodeRelation> relations) {
        for (INodeRelation relation : relations) {
            if (relation.getTarget().getType() == ACLTypes.ADMIN) {
                this.readRightGained(relation.getTarget());
                continue;
            }
            if (relation.getTarget().getType() == ACLTypes.ACL_GROUP || !this.aclUtils.can(ACLPropertyDescriptors.CAN_READ, relation.getTarget().getType(), relation.getTarget().getId(), true).booleanValue()) continue;
            this.readRightGained(relation.getTarget());
        }
    }

    public void relationsRemoved(NodeDecorator decorator, Collection<INodeRelation> relations) {
        for (INodeRelation relation : relations) {
            if (relation.getTarget().getType() == ACLTypes.ACL_GROUP) {
                this.removeAclGroup(relation.getTarget());
                continue;
            }
            this.readRightLost(relation.getTarget());
        }
    }

    private void removeAclGroup(INode aclGroup) {
        for (INodeRelation relation : aclGroup.getRelations(new TypeDescriptor[0])) {
            if (relation.getTarget().getType() == ACLTypes.ACL_GROUP) {
                this.removeAclGroup(relation.getTarget());
                continue;
            }
            this.readRightLost(relation.getTarget());
        }
    }
}

