/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.acl;

import com.centreon.studio.client.acl.ACLPropertyDescriptors;
import com.centreon.studio.client.acl.ACLTypes;
import com.centreon.studio.client.acl.ACLUtils;
import com.centreon.studio.client.acl.ACLWebService;
import com.centreon.studio.client.events.sync.SyncEvent;
import com.centreon.studio.client.events.sync.SyncEventHandler;
import com.centreon.studio.client.model.node.INode;
import com.centreon.studio.client.model.node.INodeUtils;
import com.centreon.studio.client.model.node.NodeFactories;
import com.centreon.studio.client.model.object.TypeDescriptor;
import com.centreon.studio.client.model.properties.PropertyDescriptor;
import com.centreon.studio.client.model.properties.PropertyValue;
import com.centreon.studio.client.model.relation.INodeRelation;
import com.centreon.studio.client.model.relation.NodeRelationFactories;
import com.centreon.studio.client.model.repository.IRepository;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ACLSyncEventHandler
extends SyncEventHandler {
    private static final String TARGET_OBJECT_TYPE = "targetObjectType";
    private static final String ACL_GROUP_ID = "aclGroupId";
    private static final String ACTION_TYPE = "actionType";
    private final IRepository repository;
    private final ACLWebService service;
    private final ACLUtils utils;

    public ACLSyncEventHandler(IRepository repository, ACLWebService service, ACLUtils utils) {
        super(Arrays.asList(ACLTypes.ACL_RULE.getId(), ACLTypes.ACL_GROUP.getId(), ACLTypes.ADMIN.getId()));
        this.repository = repository;
        this.service = service;
        this.utils = utils;
    }

    public void handleEvent(SyncEvent event) {
        TypeDescriptor type = TypeDescriptor.getType((Integer)event.getType());
        if (type == ACLTypes.ACL_GROUP) {
            this.handleAclGroupEvent(event);
        } else if (type == ACLTypes.ACL_RULE) {
            for (SyncEvent.SyncData data : event.getData()) {
                Integer targetObjectType = Integer.parseInt(data.getProperty(TARGET_OBJECT_TYPE).toString());
                if (targetObjectType == -1 && data.getId() == -1L) {
                    this.handleAdminAclRule();
                    return;
                }
                this.handleAclRuleEvent(data, event.getAction());
            }
        }
    }

    private void createAndFetchNewAclGroup(INodeRelation aclGroupRelation) {
        Set<TypeDescriptor> types = this.utils.getTypesUnderACL();
        Collection<INodeRelation> aclRules = this.service.getAclRules(aclGroupRelation.getTarget(), types);
        aclGroupRelation.getTarget().addRelations(aclRules);
        this.repository.addRelation(aclGroupRelation);
    }

    private void handleAclGroupEvent(SyncEvent event) {
        if (event.getAction() == SyncEvent.SyncAction.CREATE) {
            Collection datas = event.getData();
            ArrayList<Long> ids = new ArrayList<Long>(datas.size());
            for (SyncEvent.SyncData data : datas) {
                ids.add(data.getId());
            }
            for (INodeRelation aclGroupRelation : this.service.getRelationsByIds(ids)) {
                this.createAndFetchNewAclGroup(aclGroupRelation);
            }
        } else if (event.getAction() == SyncEvent.SyncAction.REMOVE) {
            TypeDescriptor type = TypeDescriptor.getType((Integer)event.getType());
            for (SyncEvent.SyncData data : event.getData()) {
                INodeRelation relation = INodeUtils.findRelationForTarget((INode)this.repository, (TypeDescriptor)type, (Long)data.getId(), (PropertyValue[])new PropertyValue[0]);
                if (relation == null) continue;
                this.repository.removeRelation(relation);
            }
        } else if (event.getAction() == SyncEvent.SyncAction.UPDATE) {
            this.handleAclGroupEvent(new SyncEvent(SyncEvent.SyncAction.REMOVE, event.getType(), event.getData()));
            this.handleAclGroupEvent(new SyncEvent(SyncEvent.SyncAction.CREATE, event.getType(), event.getData()));
        }
    }

    private void handleAclRuleEvent(SyncEvent.SyncData data, SyncEvent.SyncAction action) {
        Long aclGroupId = Long.valueOf(data.getProperty(ACL_GROUP_ID).toString());
        INode aclGroup = INodeUtils.findNode((INode)this.repository, (TypeDescriptor)ACLTypes.ACL_GROUP, (Long)aclGroupId, (PropertyValue[])new PropertyValue[0]);
        if (aclGroup == null) {
            return;
        }
        int targetObjectType = Integer.parseInt(data.getProperty(TARGET_OBJECT_TYPE).toString());
        int actionType = Integer.valueOf(data.getProperty(ACTION_TYPE).toString());
        TypeDescriptor targetObjectTypeDescriptor = TypeDescriptor.getType((Integer)targetObjectType);
        PropertyDescriptor<Boolean> pd = ACLWebService.ID_TO_PD.get(actionType);
        boolean isCreate = action == SyncEvent.SyncAction.CREATE;
        ArrayList<PropertyValue> properties = new ArrayList<PropertyValue>(2);
        properties.add(new PropertyValue(ACLPropertyDescriptors.ACL_GROUP_ID, (Object)aclGroupId));
        properties.add(new PropertyValue(pd, (Object)isCreate));
        INode aclRule = INodeUtils.findNode((INode)aclGroup, (TypeDescriptor)targetObjectTypeDescriptor, (Long)data.getId(), (PropertyValue[])new PropertyValue[0]);
        if (aclRule != null) {
            aclRule.addPropertyValue(pd, (Object)isCreate);
        } else {
            aclRule = NodeFactories.INSTANCE.create(TypeDescriptor.getType((Integer)targetObjectType), data.getId(), properties, this.repository);
            aclGroup.addRelation(NodeRelationFactories.INSTANCE.create(aclRule.getType(), aclRule.getId(), aclGroup, aclRule));
        }
    }

    private void handleAdminAclRule() {
        this.repository.removeRelations((Collection)this.repository.getRelations(new TypeDescriptor[0]));
        this.repository.addRelations(this.service.getRelationsByIds(Collections.emptyList()));
        List aclGroupRelations = this.repository.getRelations(new TypeDescriptor[]{ACLTypes.ACL_GROUP});
        ArrayList<INode> aclGroups = new ArrayList<INode>(aclGroupRelations.size());
        for (INodeRelation aclGroupRelation : aclGroupRelations) {
            aclGroups.add(aclGroupRelation.getTarget());
        }
        Map<INode, Collection<INodeRelation>> aclGroupToAclRules = this.service.getAclRules(aclGroups, this.utils.getTypesUnderACL());
        for (Map.Entry<INode, Collection<INodeRelation>> aclGroupToAclRule : aclGroupToAclRules.entrySet()) {
            aclGroupToAclRule.getKey().addRelations(aclGroupToAclRule.getValue());
        }
    }
}

