/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.acl;

import com.centreon.studio.client.acl.ACLRepository;
import com.centreon.studio.client.acl.ACLTypes;
import com.centreon.studio.client.commons.CommonUtils;
import com.centreon.studio.client.model.node.INode;
import com.centreon.studio.client.model.node.INodeUtils;
import com.centreon.studio.client.model.object.TypeDescriptor;
import com.centreon.studio.client.model.properties.PropertyDescriptor;
import com.centreon.studio.client.model.properties.PropertyValue;
import com.centreon.studio.client.model.relation.INodeRelation;
import com.centreon.studio.client.model.repository.IRepository;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class ACLUtils {
    private final Set<TypeDescriptor> typesUnderACL = new HashSet<TypeDescriptor>(4);
    private final Map<TypeDescriptor, Map<PropertyDescriptor<Boolean>, PropertyDescriptor<Boolean>>> typesRightAlternatives = new HashMap<TypeDescriptor, Map<PropertyDescriptor<Boolean>, PropertyDescriptor<Boolean>>>(4);
    private final IRepository repository;

    public static Boolean can(INode aclNode, PropertyDescriptor<Boolean> action, TypeDescriptor type, Long id, boolean admin) {
        if (admin && ACLUtils.isAdmin(aclNode).booleanValue()) {
            return Boolean.TRUE;
        }
        PropertyValue property = new PropertyValue(action, (Object)Boolean.TRUE);
        if (INodeUtils.findNode((INode)aclNode, (TypeDescriptor)type, (Long)-1L, (PropertyValue[])new PropertyValue[]{property}) != null) {
            return Boolean.TRUE;
        }
        if (INodeUtils.findNode((INode)aclNode, (TypeDescriptor)type, (Long)id, (PropertyValue[])new PropertyValue[]{property}) != null) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static Boolean isAdmin(INode parent) {
        if (INodeUtils.findNode((INode)parent, (TypeDescriptor)ACLTypes.ADMIN, (Long)-1L, (PropertyValue[])new PropertyValue[0]) != null) {
            return true;
        }
        return false;
    }

    @Inject
    public ACLUtils(ACLRepository repository) {
        this.repository = repository;
    }

    public Boolean can(PropertyDescriptor<Boolean> action, INode target) {
        if (target == null) {
            return Boolean.FALSE;
        }
        INode actualTarget = CommonUtils.getScope((INode)target);
        PropertyDescriptor<Boolean> actualAction = this.getAlternativeAction(target.getType(), action);
        return ACLUtils.can((INode)this.repository, actualAction, actualTarget.getType(), actualTarget.getId(), true);
    }

    public Boolean can(PropertyDescriptor<Boolean> action, TypeDescriptor type, Long id, boolean admin) {
        if (!this.typesUnderACL.contains(type)) {
            return Boolean.TRUE;
        }
        if (action == null) {
            return Boolean.TRUE;
        }
        PropertyDescriptor<Boolean> actualAction = this.getAlternativeAction(type, action);
        for (INodeRelation relation : this.repository.getRelations(new TypeDescriptor[]{ACLTypes.ACL_GROUP, ACLTypes.ADMIN})) {
            if (!ACLUtils.can(relation.getTarget(), actualAction, type, id, admin).booleanValue()) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public Set<TypeDescriptor> getTypesUnderACL() {
        return Collections.unmodifiableSet(this.typesUnderACL);
    }

    public void register(TypeDescriptor type) {
        if (type == null) {
            return;
        }
        this.typesUnderACL.add(type);
    }

    public void registerAlternativeAction(TypeDescriptor type, PropertyDescriptor<Boolean> initialRight, PropertyDescriptor<Boolean> alternativeRight) {
        Map<PropertyDescriptor<Boolean>, PropertyDescriptor<Boolean>> map = this.typesRightAlternatives.get(type);
        if (map == null) {
            map = new HashMap<PropertyDescriptor<Boolean>, PropertyDescriptor<Boolean>>();
            this.typesRightAlternatives.put(type, map);
        }
        map.put(initialRight, alternativeRight);
    }

    private PropertyDescriptor<Boolean> getAlternativeAction(TypeDescriptor type, PropertyDescriptor<Boolean> action) {
        Map<PropertyDescriptor<Boolean>, PropertyDescriptor<Boolean>> alternativeActions = this.typesRightAlternatives.get(type);
        if (alternativeActions == null) {
            return action;
        }
        PropertyDescriptor<Boolean> alternativeAction = alternativeActions.get(action);
        if (alternativeAction == null) {
            return action;
        }
        return alternativeAction;
    }
}

