/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.acl;

import com.centreon.studio.client.acl.ACLPropertyDescriptors;
import com.centreon.studio.client.acl.ACLRepository;
import com.centreon.studio.client.acl.ACLTypes;
import com.centreon.studio.client.commons.Configuration;
import com.centreon.studio.client.cxf.AWebService;
import com.centreon.studio.client.events.BrokerEventManager;
import com.centreon.studio.client.events.StudioEvent;
import com.centreon.studio.client.events.exception.ExceptionEvent;
import com.centreon.studio.client.events.log.LogEvent;
import com.centreon.studio.client.model.IWebService;
import com.centreon.studio.client.model.node.INode;
import com.centreon.studio.client.model.node.INodeUtils;
import com.centreon.studio.client.model.node.NodeFactories;
import com.centreon.studio.client.model.object.AObject;
import com.centreon.studio.client.model.object.TypeDescriptor;
import com.centreon.studio.client.model.properties.PropertyDescriptor;
import com.centreon.studio.client.model.properties.PropertyValue;
import com.centreon.studio.client.model.relation.INodeRelation;
import com.centreon.studio.client.model.relation.NodeRelationFactories;
import com.centreon.studio.client.model.repository.IRepository;
import com.centreon.studio.client.utils.StepTimeTracker;
import com.centreon.studio.map.acl.AclGroupDto;
import com.centreon.studio.map.acl.AclRuleDto;
import com.centreon.studio.map.aclservice.AclPortType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class ACLWebService
extends AWebService<AclPortType>
implements IWebService {
    protected static final Map<Integer, PropertyDescriptor<Boolean>> ID_TO_PD = new HashMap<Integer, PropertyDescriptor<Boolean>>();
    protected static final Map<PropertyDescriptor<Boolean>, Integer> PD_TO_ID = new HashMap<PropertyDescriptor<Boolean>, Integer>();
    private final BrokerEventManager eventManager;
    private final ACLRepository repository;

    static {
        ID_TO_PD.put(0, ACLPropertyDescriptors.CAN_CREATE);
        ID_TO_PD.put(1, ACLPropertyDescriptors.CAN_READ);
        ID_TO_PD.put(2, ACLPropertyDescriptors.CAN_UPDATE);
        ID_TO_PD.put(3, ACLPropertyDescriptors.CAN_DELETE);
        PD_TO_ID.put(ACLPropertyDescriptors.CAN_CREATE, 0);
        PD_TO_ID.put(ACLPropertyDescriptors.CAN_READ, 1);
        PD_TO_ID.put(ACLPropertyDescriptors.CAN_UPDATE, 2);
        PD_TO_ID.put(ACLPropertyDescriptors.CAN_DELETE, 3);
    }

    private static void apply(INode aclRule, AclRuleDto dto) {
        if (aclRule == null) {
            return;
        }
        aclRule.addPropertyValue(ID_TO_PD.get(dto.getActionType()), (Object)Boolean.TRUE);
    }

    private static AclRuleDto createRuleDto(TypeDescriptor type, Long id, PropertyDescriptor<Boolean> action, Long aclGroupId) {
        AclRuleDto dto = new AclRuleDto();
        dto.setActionType(PD_TO_ID.get(action).intValue());
        dto.setAclGroupId(aclGroupId.longValue());
        dto.setTargetObjectId(id.longValue());
        dto.setTargetObjectType(type.getId().intValue());
        return dto;
    }

    private static void nodeToDtos(INode rule, List<AclRuleDto> toAdd, List<AclRuleDto> toDelete) {
        AclRuleDto retrieve = ACLWebService.createRuleDto(rule.getType(), rule.getId(), ACLPropertyDescriptors.CAN_READ, (Long)rule.getProperty(ACLPropertyDescriptors.ACL_GROUP_ID));
        if (Boolean.TRUE.equals(rule.getProperty(ACLPropertyDescriptors.CAN_READ))) {
            toAdd.add(retrieve);
        } else {
            toDelete.add(retrieve);
        }
        AclRuleDto update = ACLWebService.createRuleDto(rule.getType(), rule.getId(), ACLPropertyDescriptors.CAN_UPDATE, (Long)rule.getProperty(ACLPropertyDescriptors.ACL_GROUP_ID));
        if (Boolean.TRUE.equals(rule.getProperty(ACLPropertyDescriptors.CAN_UPDATE))) {
            toAdd.add(update);
        } else {
            toDelete.add(update);
        }
        AclRuleDto delete = ACLWebService.createRuleDto(rule.getType(), rule.getId(), ACLPropertyDescriptors.CAN_DELETE, (Long)rule.getProperty(ACLPropertyDescriptors.ACL_GROUP_ID));
        if (Boolean.TRUE.equals(rule.getProperty(ACLPropertyDescriptors.CAN_DELETE))) {
            toAdd.add(delete);
        } else {
            toDelete.add(delete);
        }
        AclRuleDto create = ACLWebService.createRuleDto(rule.getType(), rule.getId(), ACLPropertyDescriptors.CAN_CREATE, (Long)rule.getProperty(ACLPropertyDescriptors.ACL_GROUP_ID));
        if (Boolean.TRUE.equals(rule.getProperty(ACLPropertyDescriptors.CAN_CREATE))) {
            toAdd.add(create);
        } else {
            toDelete.add(create);
        }
    }

    @Inject
    public ACLWebService(ACLRepository repository, BrokerEventManager eventManager) {
        super("/centreon-studio/services/acl?wsdl", AclPortType.class, !Configuration.SKIP_GZIP);
        this.eventManager = eventManager;
        this.repository = repository;
    }

    public Map<INode, Collection<INodeRelation>> create(Map<INode, Collection<INodeRelation>> nodeToRelations) {
        ArrayList<INode> nodes = new ArrayList<INode>();
        for (Collection<INodeRelation> collection : nodeToRelations.values()) {
            for (INodeRelation relation : collection) {
                nodes.add(relation.getTarget());
            }
        }
        this.update(nodes);
        for (Map.Entry entry : nodeToRelations.entrySet()) {
            ((INode)entry.getKey()).addRelations((Collection)entry.getValue());
        }
        return nodeToRelations;
    }

    public Map<INode, Collection<INodeRelation>> getAclRules(Collection<INode> aclGroups, Collection<TypeDescriptor> types) {
        StepTimeTracker counter = new StepTimeTracker("ACLWebService.getAclRules() " + types.size() + " types for " + aclGroups.size() + " acl groups");
        HashMap<INode, Collection<INodeRelation>> aclGroupToAclRules = new HashMap<INode, Collection<INodeRelation>>(aclGroups.size());
        for (INode aclGroup : aclGroups) {
            aclGroupToAclRules.put(aclGroup, this.getAclRules(aclGroup, types));
        }
        this.eventManager.async((StudioEvent)LogEvent.trace(((Object)((Object)this)).getClass(), (String)counter.finish(), (Object[])new Object[0]));
        return aclGroupToAclRules;
    }

    public Collection<INodeRelation> getAclRules(INode aclGroup, Collection<TypeDescriptor> types) {
        if (!this.isInit()) {
            return Collections.emptyList();
        }
        ArrayList<Integer> typeCollection = new ArrayList<Integer>(types.size());
        for (TypeDescriptor type : types) {
            typeCollection.add(type.getId());
        }
        try {
            List dtos = ((AclPortType)this.service).getAclRules(aclGroup.getId().longValue(), typeCollection, Collections.emptyList());
            ArrayList<INodeRelation> aclRules = new ArrayList<INodeRelation>(dtos.size());
            for (AclRuleDto dto : dtos) {
                TypeDescriptor dtoType = TypeDescriptor.getType((Integer)dto.getTargetObjectType());
                if (dtoType == null) {
                    this.eventManager.async((StudioEvent)LogEvent.error(ACLWebService.class, (String)"couldn't find type {}", (Object[])new Object[]{dto.getTargetObjectType()}));
                    continue;
                }
                INode aclRule = this.findACLRule(aclRules, aclGroup, dtoType, dto.getTargetObjectId());
                ACLWebService.apply(aclRule, dto);
            }
            return aclRules;
        }
        catch (Exception e) {
            this.eventManager.async((StudioEvent)new ExceptionEvent((Throwable)e));
            return Collections.emptyList();
        }
    }

    public List<INodeRelation> getElementsByIds(List<Long> ids) {
        throw new UnsupportedOperationException();
    }

    public List<INodeRelation> getElementsByTypes(List<TypeDescriptor> types) {
        return this.getRelationsByIds(Collections.emptyList());
    }

    public List<INodeRelation> getRelationsByIds(List<Long> ids) {
        if (!this.isInit()) {
            return Collections.emptyList();
        }
        List<Object> nonNullIds = ids == null ? Collections.emptyList() : ids;
        ArrayList<INodeRelation> aclGroups = new ArrayList<INodeRelation>(nonNullIds.size());
        StepTimeTracker counter = new StepTimeTracker("ACLWebService.get() " + nonNullIds.size());
        try {
            List dtos = ((AclPortType)this.service).getAclGroups(nonNullIds);
            for (AclGroupDto dto : dtos) {
                TypeDescriptor type = dto.getAclGroupId() == 0L ? ACLTypes.ADMIN : ACLTypes.ACL_GROUP;
                INode aclGroup = NodeFactories.INSTANCE.create(type, Long.valueOf(dto.getAclGroupId()), Arrays.asList(new PropertyValue(AObject.LABEL, (Object)dto.getLabel())), (IRepository)this.repository);
                aclGroups.add(NodeRelationFactories.INSTANCE.create((INode)this.repository, aclGroup));
            }
            ArrayList<INodeRelation> arrayList = aclGroups;
            return arrayList;
        }
        catch (Exception e) {
            this.eventManager.async((StudioEvent)new ExceptionEvent((Throwable)e));
        }
        finally {
            this.eventManager.async((StudioEvent)LogEvent.trace(((Object)((Object)this)).getClass(), (String)counter.finish(), (Object[])new Object[0]));
        }
        return Collections.emptyList();
    }

    public boolean remove(Map<INode, Collection<INodeRelation>> nodeToRelations) {
        ArrayList<PropertyValue> properties = new ArrayList<PropertyValue>(4);
        properties.add(new PropertyValue(ACLPropertyDescriptors.CAN_READ, (Object)Boolean.FALSE));
        properties.add(new PropertyValue(ACLPropertyDescriptors.CAN_CREATE, (Object)Boolean.FALSE));
        properties.add(new PropertyValue(ACLPropertyDescriptors.CAN_UPDATE, (Object)Boolean.FALSE));
        properties.add(new PropertyValue(ACLPropertyDescriptors.CAN_DELETE, (Object)Boolean.FALSE));
        ArrayList<INode> nodes = new ArrayList<INode>();
        for (Collection<INodeRelation> collection : nodeToRelations.values()) {
            for (INodeRelation relation : collection) {
                relation.getTarget().addPropertyValues(properties);
                nodes.add(relation.getTarget());
            }
        }
        this.update(nodes);
        for (Map.Entry entry : nodeToRelations.entrySet()) {
            ((INode)entry.getKey()).removeRelations((Collection)entry.getValue());
        }
        return true;
    }

    public void update(Collection<INode> objects) {
        if (!this.isInit()) {
            return;
        }
        ArrayList<AclRuleDto> toAdd = new ArrayList<AclRuleDto>(objects.size());
        ArrayList<AclRuleDto> toDelete = new ArrayList<AclRuleDto>(objects.size());
        for (INode node : objects) {
            ACLWebService.nodeToDtos(node, toAdd, toDelete);
        }
        try {
            ((AclPortType)this.service).setAclRules(toAdd);
        }
        catch (Exception e) {
            this.eventManager.async((StudioEvent)new ExceptionEvent((Throwable)e));
        }
        try {
            ((AclPortType)this.service).removeAclRules(toDelete);
        }
        catch (Exception e) {
            this.eventManager.async((StudioEvent)new ExceptionEvent((Throwable)e));
        }
    }

    public void updateRelation(Collection<INodeRelation> relations) {
    }

    protected boolean isWebServiceInitialized() {
        try {
            ((AclPortType)this.service).getAclGroups(Arrays.asList(-1L));
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private INode findACLRule(Collection<INodeRelation> cache, INode aclGroup, TypeDescriptor type, Long id) {
        INodeRelation aclRule2;
        for (INodeRelation aclRule2 : cache) {
            if (!aclRule2.getTarget().getType().equals((Object)type) || !aclRule2.getTarget().getId().equals(id)) continue;
            return aclRule2.getTarget();
        }
        aclRule2 = INodeUtils.findNode((INode)aclGroup, (TypeDescriptor)type, (Long)id, (PropertyValue[])new PropertyValue[0]);
        if (aclRule2 != null) {
            return aclRule2;
        }
        ArrayList<PropertyValue> properties = new ArrayList<PropertyValue>(1);
        properties.add(new PropertyValue(ACLPropertyDescriptors.ACL_GROUP_ID, (Object)aclGroup.getId()));
        aclRule2 = NodeFactories.INSTANCE.create(type, id, properties, aclGroup.getRepository());
        if (aclRule2 != null) {
            cache.add(NodeRelationFactories.INSTANCE.create(aclRule2.getType(), aclRule2.getId(), aclGroup, (INode)aclRule2));
        } else {
            this.eventManager.async((StudioEvent)LogEvent.error(ACLWebService.class, (String)"couldn't create rule type {} id {}", (Object[])new Object[]{type, id}));
        }
        return aclRule2;
    }
}

