/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client;

import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.Straight;
import org.eclipse.draw2d.geometry.Vector;

public class GeometricUtils {
    public static PrecisionPoint applyTranslsation(Point s, Point p1, Point p2) {
        return new PrecisionPoint(s.x + p2.x - p1.x, s.y + p2.y - p1.y);
    }

    public static Vector getOrthogalVectorScaledTo(Vector v, double l) {
        Vector ov = v.getOrthogonalComplement();
        try {
            if (ov.getLength() == 0.0) {
                return v;
            }
            return ov.getMultiplied(l / ov.getLength());
        }
        catch (NumberFormatException numberFormatException) {
            return v;
        }
    }

    public static Straight getParallelStraight(PrecisionPoint pp1, PrecisionPoint pp2, int actualWidth) {
        Vector direction = new Vector(pp1, pp2);
        Vector v = GeometricUtils.getOrthogalVectorScaledTo(direction, actualWidth);
        Vector source = new Vector((double)pp1.x + v.x, (double)pp1.y + v.y);
        return new Straight(source, direction);
    }

    public static PointList toRelative(PointList points) {
        Point first = points.getFirstPoint();
        PointList relativePoints = new PointList();
        int i = 0;
        while (i < points.size()) {
            Point connectionPoint = points.getPoint(i);
            relativePoints.addPoint(connectionPoint.x - first.x, connectionPoint.y - first.y);
            ++i;
        }
        return relativePoints;
    }

    private GeometricUtils() {
    }

    public static class LineEquation {
        private final double a;
        private final double b;

        public LineEquation(Point p1, Point p2) {
            this.a = (double)(p2.y - p1.y) / (double)(p2.x - p1.x);
            this.b = (double)p2.y - this.a * (double)p2.x;
        }

        public boolean superior(int x, int y) {
            return (double)y > (double)x * this.a + this.b;
        }
    }
}

