/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.draw2d;

import org.eclipse.draw2d.FanRouter;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.Vector;

public class CustomFanRouter
extends FanRouter {
    protected void handleCollision(PointList points, int index) {
        PrecisionPoint bendPointEnd;
        PrecisionPoint bendPointStart;
        PrecisionPoint midEndPoint;
        PrecisionPoint midStartPoint;
        Vector vector;
        PrecisionPoint start = new PrecisionPoint(points.getFirstPoint());
        PrecisionPoint end = new PrecisionPoint(points.getLastPoint());
        if (index == 0 || start.equals((Object)end)) {
            return;
        }
        int position = end.getPosition((Point)start);
        if (position == 4 || position == 16) {
            vector = new Vector(start, end);
            midStartPoint = new PrecisionPoint((double)start.x + vector.x * 0.1, (double)start.y + vector.y * 0.1);
            midEndPoint = new PrecisionPoint((double)start.x + vector.x * 0.9, (double)start.y + vector.y * 0.9);
        } else {
            vector = new Vector(end, start);
            midStartPoint = new PrecisionPoint((double)end.x + vector.x * 0.1, (double)end.y + vector.y * 0.1);
            midEndPoint = new PrecisionPoint((double)end.x + vector.x * 0.9, (double)end.y + vector.y * 0.9);
        }
        double length = vector.getLength();
        double xSeparation = (double)this.getSeparation() * vector.x / length;
        double ySeparation = (double)this.getSeparation() * vector.y / length;
        int factor = index / 2;
        if (index % 2 == 0) {
            bendPointStart = new PrecisionPoint((double)midStartPoint.x + (double)factor * (-1.0 * ySeparation), (double)midStartPoint.y + (double)factor * xSeparation);
            bendPointEnd = new PrecisionPoint((double)midEndPoint.x + (double)factor * (-1.0 * ySeparation), (double)midEndPoint.y + (double)factor * xSeparation);
        } else {
            bendPointStart = new PrecisionPoint((double)midStartPoint.x + (double)factor * ySeparation, (double)midStartPoint.y + (double)factor * (-1.0 * xSeparation));
            bendPointEnd = new PrecisionPoint((double)midEndPoint.x + (double)factor * ySeparation, (double)midEndPoint.y + (double)factor * (-1.0 * xSeparation));
        }
        if (position == 4 || position == 16) {
            points.insertPoint((Point)bendPointStart, 1);
            points.insertPoint((Point)bendPointEnd, points.size() - 1);
        } else {
            points.insertPoint((Point)bendPointEnd, 1);
            points.insertPoint((Point)bendPointStart, points.size() - 1);
        }
    }
}

