/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.gef;

import com.centreon.studio.client.gef.palette.ContextCreationTool;
import com.centreon.studio.client.gef.palette.ContextCreationToolEntry;
import com.centreon.studio.client.gef.palette.CreationTool;
import java.util.List;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.Tool;
import org.eclipse.gef.internal.ui.palette.editparts.ToolEntryEditPart;
import org.eclipse.gef.tools.ConnectionCreationTool;
import org.eclipse.gef.tools.SelectionTool;
import org.eclipse.gef.ui.palette.PaletteViewer;

public final class CustomEditDomain
extends EditDomain {
    private static CustomEditDomain instance;
    private ToolEntryEditPart previousToolEntry;

    private CustomEditDomain() {
    }

    public static final synchronized CustomEditDomain getInstance() {
        if (instance == null) {
            instance = new CustomEditDomain();
        }
        return instance;
    }

    public void resetToolToDefault() {
        this.setActiveTool(this.getDefaultTool());
    }

    public void setActiveTool(Tool tool) {
        super.setActiveTool(tool);
        PaletteViewer viewer = this.getPaletteViewer();
        if (viewer == null) {
            return;
        }
        List entries = this.retrieveEntriesFromViewer(viewer);
        if (tool == null || tool instanceof SelectionTool) {
            for (Object entry : entries) {
                if (!(entry instanceof ToolEntryEditPart)) continue;
                ((ToolEntryEditPart)entry).setToolSelected(false);
            }
        } else {
            String selectedToolLabel = this.labelFromTool(tool);
            if (this.previousToolEntry != null) {
                if (this.labelFromPreviousEntryEditPart().equals(selectedToolLabel)) {
                    return;
                }
                this.previousToolEntry.setToolSelected(false);
                this.previousToolEntry = null;
            }
            this.previousToolEntry = this.retrieveEntryEditPart(entries, selectedToolLabel);
        }
    }

    private ToolEntryEditPart retrieveEntryEditPart(List entries, String toolLabel) {
        for (Object entry : entries) {
            String currentToolLabel;
            ToolEntryEditPart toolEntryEditPart;
            Object model;
            if (!(entry instanceof ToolEntryEditPart) || !((model = (toolEntryEditPart = (ToolEntryEditPart)entry).getModel()) instanceof ContextCreationToolEntry) || !(currentToolLabel = ((ContextCreationToolEntry)((Object)model)).getToolLabel()).equals(toolLabel)) continue;
            return toolEntryEditPart;
        }
        return null;
    }

    private List retrieveEntriesFromViewer(PaletteViewer viewer) {
        RootEditPart rootEditPart = viewer.getRootEditPart();
        List children = rootEditPart.getChildren();
        EditPart editPart = (EditPart)children.get(0);
        children = editPart.getChildren();
        EditPart lastOne = (EditPart)children.get(0);
        return lastOne.getChildren();
    }

    private String labelFromPreviousEntryEditPart() {
        return ((ContextCreationToolEntry)((Object)this.previousToolEntry.getModel())).getToolLabel();
    }

    private String labelFromTool(Tool tool) {
        if (tool instanceof ContextCreationTool) {
            ContextCreationTool ctxtCreationTool = (ContextCreationTool)tool;
            return ctxtCreationTool.getToolLabel();
        }
        if (tool instanceof ConnectionCreationTool) {
            return CreationTool.LINK.label;
        }
        return CreationTool.LINK_TEMPLATE.label;
    }
}

