/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.gef;

import com.centreon.studio.client.model.Pos;
import com.centreon.studio.client.model.ui.actions.zoom.IZoomable;
import org.eclipse.draw2d.ScalableFigure;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.editparts.ZoomManager;

public class CustomZoomManager
extends ZoomManager
implements IZoomable {
    private IZoomable delegate;

    public CustomZoomManager(ScalableFigure pane, Viewport viewport) {
        super(pane, viewport);
    }

    public double getDefaultZoom() {
        if (this.delegate != null) {
            return this.delegate.getDefaultZoom();
        }
        return 1.0;
    }

    public double getMaxZoom() {
        if (this.delegate != null) {
            return this.delegate.getMaxZoom();
        }
        return super.getMaxZoom();
    }

    public double getMinZoom() {
        if (this.delegate != null) {
            return this.delegate.getMinZoom();
        }
        return super.getMinZoom();
    }

    public double getNextZoomLevel() {
        double[] zoomLevels;
        double zoom = this.getZoom();
        double[] dArray = zoomLevels = this.getZoomLevels();
        int n = zoomLevels.length;
        int n2 = 0;
        while (n2 < n) {
            double zoomLevel = dArray[n2];
            if (zoomLevel > zoom) {
                return zoomLevel;
            }
            ++n2;
        }
        return this.getMaxZoom();
    }

    public double getPreviousZoomLevel() {
        double zoom = this.getZoom();
        double[] zoomLevels = this.getZoomLevels();
        int i = 1;
        while (i < zoomLevels.length) {
            if (zoomLevels[i] >= zoom) {
                return zoomLevels[i - 1];
            }
            ++i;
        }
        return this.getMinZoom();
    }

    public double getZoom() {
        if (this.delegate != null) {
            return this.delegate.getZoom();
        }
        return super.getZoom();
    }

    public double[] getZoomLevels() {
        if (this.delegate != null) {
            return this.delegate.getZoomLevels();
        }
        return new double[]{0.1, 0.25, 0.5, 0.75, 1.0, 1.5, 2.0, 3.0, 4.0, 6.0, 8.0, 10.0};
    }

    public void setZoom(double zoom) {
        this.setZoom(-1, -1, zoom);
    }

    public void setZoom(int x, int y, double zoom) {
        if (this.delegate != null) {
            this.delegate.setZoom(x, y, zoom);
        } else {
            Viewport viewport = this.getViewport();
            Rectangle bounds = viewport.getBounds();
            Pos dim = Pos.create((double)bounds.width, (double)bounds.height);
            Pos delta = Pos.create((double)x, (double)y).minus(dim.div(2.0));
            Point viewLocation = viewport.getViewLocation();
            viewport.setViewLocation(viewLocation.x + delta.x.intValue(), viewLocation.y + delta.y.intValue());
            super.setZoom(zoom);
        }
    }

    public void setZoomDelegate(IZoomable delegate) {
        this.delegate = delegate;
    }

    public void zoomIn() {
        this.zoomIn(-1, -1);
    }

    public void zoomIn(int x, int y) {
        if (this.delegate != null) {
            this.delegate.zoomIn(x, y);
        } else {
            this.setZoom(x, y, this.getNextZoomLevel());
        }
    }

    public void zoomOut() {
        this.zoomOut(-1, -1);
    }

    public void zoomOut(int x, int y) {
        if (this.delegate != null) {
            this.delegate.zoomOut(x, y);
        } else {
            this.setZoom(x, y, this.getPreviousZoomLevel());
        }
    }
}

