/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.gef;

import com.centreon.studio.client.gef.IEditPartFactory;
import com.centreon.studio.client.gef.editparts.DefaultGraphicalEditPart;
import com.centreon.studio.client.gef.editparts.DefaultInputGraphicalEditPart;
import com.centreon.studio.client.gef.editparts.INodeEditPart;
import com.centreon.studio.client.model.object.TypeDescriptor;
import com.centreon.studio.client.model.relation.INodeRelation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;

public enum EditPartFactories implements IEditPartFactory
{
    INSTANCE;

    private final Map<TypeDescriptor, Class<? extends INodeEditPart>> childrenEditParts = new HashMap<TypeDescriptor, Class<? extends INodeEditPart>>(8);
    private final Map<TypeDescriptor, Class<? extends INodeEditPart>> inputEditParts = new HashMap<TypeDescriptor, Class<? extends INodeEditPart>>(8);
    private final Map<TypeDescriptor, IEditPartFactory> factories = new HashMap<TypeDescriptor, IEditPartFactory>(8);

    public static <T extends GraphicalEditPart> T createPart(Class<T> clazz, INodeRelation model) {
        if (clazz == null) {
            return null;
        }
        boolean accessible = true;
        Constructor<T> constructor = null;
        try {
            constructor = clazz.getDeclaredConstructor(INodeRelation.class);
            if (!constructor.isAccessible()) {
                constructor.setAccessible(true);
                accessible = false;
            }
            GraphicalEditPart graphicalEditPart = (GraphicalEditPart)constructor.newInstance(model);
            return (T)graphicalEditPart;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            e.printStackTrace();
        }
        finally {
            if (constructor != null && !accessible) {
                constructor.setAccessible(false);
            }
        }
        return null;
    }

    public void addGraphicalEditPartMapping(TypeDescriptor type, Class<? extends INodeEditPart> graphicalPart) {
        this.childrenEditParts.put(type, graphicalPart);
    }

    @Override
    public synchronized INodeEditPart createEditPart(EditPart context, Object model) {
        if (!(model instanceof INodeRelation)) {
            return null;
        }
        INodeRelation relation = (INodeRelation)model;
        TypeDescriptor type = relation.getTarget().getType();
        IEditPartFactory factory = this.factories.get(type);
        INodeEditPart part = null;
        part = factory != null ? factory.createEditPart(context, relation) : (context == null ? EditPartFactories.createPart(this.inputEditParts.get(type), relation) : EditPartFactories.createPart(this.childrenEditParts.get(type), relation));
        if (part == null) {
            if (context == null) {
                return new DefaultInputGraphicalEditPart(relation, new TypeDescriptor[0]);
            }
            return new DefaultGraphicalEditPart(relation);
        }
        return part;
    }

    public Set<TypeDescriptor> getSupportedTypes() {
        return Collections.unmodifiableSet(this.factories.keySet());
    }

    public synchronized void register(IEditPartFactory factory) {
        Assert.isTrue((factory != null && factory.getSupportedTypes() != null ? 1 : 0) != 0, (String)"factory and supported types must not be null");
        for (TypeDescriptor supportedType : factory.getSupportedTypes()) {
            this.factories.put(supportedType, factory);
        }
    }
}

