/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.gef.editparts;

import com.centreon.studio.client.commons.swt.SWTUtils;
import com.centreon.studio.client.gef.GEFPropertyDescriptors;
import com.centreon.studio.client.gef.editparts.ANodeRelationGraphicalEditPart;
import com.centreon.studio.client.gef.editparts.INodeEditPart;
import com.centreon.studio.client.gef.editpolicies.NodeLayoutEditPolicy;
import com.centreon.studio.client.gef.figures.INodeFigure;
import com.centreon.studio.client.gef.figures.NodeFreeformLayer;
import com.centreon.studio.client.model.Pos;
import com.centreon.studio.client.model.StudioTypes;
import com.centreon.studio.client.model.node.INode;
import com.centreon.studio.client.model.node.INodeRelationListener;
import com.centreon.studio.client.model.object.IObject;
import com.centreon.studio.client.model.object.IPropertiesListener;
import com.centreon.studio.client.model.object.TypeDescriptor;
import com.centreon.studio.client.model.properties.PropertyValue;
import com.centreon.studio.client.model.property.PropertyDescriptors;
import com.centreon.studio.client.model.relation.INodeRelation;
import com.centreon.studio.client.model.ui.actions.edit.RemoveNodesAction;
import com.centreon.studio.client.model.ui.actions.layer.LayersRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.draw2d.FigureListener;
import org.eclipse.draw2d.FreeformLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.SnapToGrid;
import org.eclipse.gef.SnapToHelper;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.gef.editparts.ZoomListener;

public class DefaultInputGraphicalEditPart
extends AbstractGraphicalEditPart
implements INodeEditPart,
IPropertiesListener,
FigureListener,
INodeRelationListener,
ZoomListener {
    private static final int SPACE_H = 98;
    private static final int SPACE_V = 98;
    protected Dimension size;
    protected final TypeDescriptor[] types;

    public DefaultInputGraphicalEditPart(INodeRelation relation, TypeDescriptor ... types) {
        super.setModel((Object)relation);
        this.types = types;
    }

    public void activate() {
        super.activate();
        this.getModel().getTarget().registerRelationsListener((INodeRelationListener)this);
        this.getModel().getTarget().registerPropertiesListener((IPropertiesListener)this);
    }

    public void deactivate() {
        super.deactivate();
        this.getModel().getTarget().unregisterRelationsListener((INodeRelationListener)this);
        this.getModel().getTarget().unregisterPropertiesListener((IPropertiesListener)this);
        for (Object child : this.getChildren()) {
            GraphicalEditPart part = (GraphicalEditPart)child;
            this.removeChildVisual((EditPart)part);
        }
    }

    public void figureMoved(IFigure source) {
        this.refreshVisuals();
    }

    public Object getAdapter(Class key) {
        if (key == SnapToHelper.class && Boolean.TRUE.equals(this.getViewer().getProperty("SnapToGrid.isEnabled"))) {
            return new SnapToGrid((GraphicalEditPart)this);
        }
        return super.getAdapter(key);
    }

    public DragTracker getDragTracker(Request request) {
        return null;
    }

    @Override
    public INodeFigure getFigure() {
        return (INodeFigure)super.getFigure();
    }

    @Override
    public final INodeRelation getModel() {
        return (INodeRelation)super.getModel();
    }

    public void propertiesChanged(IObject object, Collection<PropertyValue> propertyValues) {
        for (PropertyValue pv : propertyValues) {
            if (PropertyDescriptors.LAST_UPDATED.equals((Object)pv.getProperty())) {
                this.refreshConnections();
                continue;
            }
            if (!GEFPropertyDescriptors.SHOW_GRID.equals((Object)pv.getProperty())) continue;
            this.getViewer().setProperty("SnapToGrid.isVisible", pv.getValue());
            this.getViewer().setProperty("SnapToGrid.isEnabled", pv.getValue());
        }
    }

    @Override
    public void refreshConnections() {
        List children = this.getChildren();
        for (Object child : children) {
            ((INodeEditPart)child).refreshConnections();
        }
    }

    public final void relationsAdded(INode node, Collection<INodeRelation> relations) {
        if (relations.isEmpty()) {
            return;
        }
        SWTUtils.getDisplay().syncExec(() -> {
            this.refresh();
            for (INodeRelation relation : relations) {
                if (!relation.getType().equals((Object)StudioTypes.RELATION_LINK)) continue;
                this.refreshConnections();
                return;
            }
        });
    }

    public final void relationsRemoved(INode node, Collection<INodeRelation> relations) {
        if (relations.isEmpty()) {
            return;
        }
        SWTUtils.getDisplay().syncExec(() -> {
            this.refresh();
            for (INodeRelation relation : relations) {
                if (!relation.getType().equals((Object)StudioTypes.RELATION_LINK)) continue;
                this.refreshConnections();
                return;
            }
        });
    }

    @Override
    public final void removeChild(EditPart child) {
        if (child instanceof INodeEditPart) {
            INodeEditPart nodeEditPart = (INodeEditPart)child;
            INodeRelation nodeRelation = nodeEditPart.getModel();
            List relations = nodeRelation.getSource().getRelations(new TypeDescriptor[]{nodeRelation.getType()});
            if (!relations.contains(nodeRelation)) {
                ArrayList<INodeRelation> toRemove = new ArrayList<INodeRelation>();
                ArrayList connections = new ArrayList();
                connections.addAll(nodeEditPart.getSourceConnections());
                connections.addAll(nodeEditPart.getTargetConnections());
                for (Object connection : connections) {
                    if (!(connection instanceof INodeEditPart)) continue;
                    INodeEditPart nodeConnectionEditPart = (INodeEditPart)connection;
                    toRemove.add(nodeConnectionEditPart.getModel());
                }
                if (!toRemove.isEmpty()) {
                    this.getModel().getRepository().setSelection((Object)this, toRemove);
                    new RemoveNodesAction(this.getModel().getRepository(), false, false, true).run();
                }
            }
        }
        super.removeChild(child);
        SWTUtils.getDisplay().syncExec(() -> this.refresh());
        for (Object part : this.getChildren()) {
            ((EditPart)part).refresh();
        }
    }

    public final void setModel(Object model) {
        throw new UnsupportedOperationException("model must be set at constructor time");
    }

    public void zoomChanged(double zoom) {
        this.getModel().getTarget().addPropertyValue(PropertyDescriptors.CURRENT_ZOOM, (Object)zoom);
    }

    protected void addChildVisual(EditPart childEditPart, int index) {
        if (childEditPart instanceof ANodeRelationGraphicalEditPart) {
            ANodeRelationGraphicalEditPart part = (ANodeRelationGraphicalEditPart)childEditPart;
            String layerName = LayersRegistry.parse((String)((String)part.getModel().getTarget().getProperty(PropertyDescriptors.LAYER))).toString();
            INodeFigure figure = part.getFigure();
            IFigure layer = this.getLayer(layerName);
            if (layer != null) {
                layer.add((IFigure)figure, -1);
                return;
            }
        }
        super.addChildVisual(childEditPart, -1);
    }

    protected void computeAutoPos() {
        int i = 0;
        List<INodeRelation> children = this.getModelChildren();
        for (INodeRelation relation : children) {
            Pos defaultPos = (Pos)relation.getProperty(PropertyDescriptors.DEFAULT_POSITION);
            Pos currentPos = (Pos)relation.getProperty(PropertyDescriptors.CURRENT_POSITION);
            if (!Pos.NULL.equals((Object)currentPos) && !defaultPos.equals((Object)currentPos)) continue;
            relation.addPropertyValue(PropertyDescriptors.DEFAULT_POSITION, (Object)this.computeAutoPosition(i++));
        }
    }

    protected void createEditPolicies() {
        this.getViewer().getContents().installEditPolicy(NodeLayoutEditPolicy.class, (EditPolicy)new NodeLayoutEditPolicy());
    }

    protected IFigure createFigure() {
        RootEditPart root = this.getRoot();
        if (root instanceof ScalableFreeformRootEditPart) {
            ScalableFreeformRootEditPart scalableFreeformRootEditPart = (ScalableFreeformRootEditPart)root;
            scalableFreeformRootEditPart.getZoomManager().addZoomListener((ZoomListener)this);
        }
        NodeFreeformLayer figure = new NodeFreeformLayer();
        figure.setLayoutManager((LayoutManager)new FreeformLayout());
        figure.addFigureListener(this);
        return figure;
    }

    protected List<INodeRelation> getModelChildren() {
        return this.getModel().getTarget().getRelations(this.types);
    }

    protected boolean needComputeAutoPos() {
        return !this.getSize().isEmpty() && !this.getSize().equals((Object)this.size);
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        if (this.needComputeAutoPos()) {
            this.size = this.getSize();
            this.computeAutoPos();
        }
    }

    protected void removeChildVisual(EditPart childEditPart) {
        if (childEditPart instanceof INodeEditPart) {
            INodeEditPart part = (INodeEditPart)childEditPart;
            String layerName = LayersRegistry.parse((String)((String)part.getModel().getTarget().getProperty(PropertyDescriptors.LAYER))).toString();
            INodeFigure figure = part.getFigure();
            IFigure layer = this.getLayer(layerName);
            try {
                layer.remove((IFigure)figure);
                return;
            }
            catch (RuntimeException e) {
                e.printStackTrace();
            }
        }
        super.removeChildVisual(childEditPart);
    }

    private Pos computeAutoPosition(int index) {
        int elementsByLine = Math.max(1, (this.size.width - 98) / 98);
        int xIndex = index % elementsByLine;
        int yIndex = (index - xIndex) / elementsByLine;
        return Pos.create((double)(49 + 98 * xIndex), (double)(49 + 98 * yIndex));
    }

    private Dimension getSize() {
        Double zoom = (Double)this.getModel().getTarget().getProperty(PropertyDescriptors.CURRENT_ZOOM);
        IFigure figure = ((GraphicalEditPart)this.getParent()).getFigure();
        return figure.getSize().scale(1.0 / zoom);
    }
}

