/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.gef.editpolicies;

import com.centreon.studio.client.acl.ACLPropertyDescriptors;
import com.centreon.studio.client.gef.commands.YesCommand;
import com.centreon.studio.client.gef.editparts.ANodeRelationGraphicalEditPart;
import com.centreon.studio.client.gef.editparts.CustomScalableFreeformRootEditPart;
import com.centreon.studio.client.gef.palette.ContextCreationTool;
import com.centreon.studio.client.gef.palette.CustomCreationFactory;
import com.centreon.studio.client.model.ListOfPos;
import com.centreon.studio.client.model.Pos;
import com.centreon.studio.client.model.TypeHierarchy;
import com.centreon.studio.client.model.node.INode;
import com.centreon.studio.client.model.object.TypeDescriptor;
import com.centreon.studio.client.model.properties.PropertyValue;
import com.centreon.studio.client.model.property.PropertyDescriptors;
import com.centreon.studio.client.model.relation.INodeRelation;
import com.centreon.studio.client.model.relation.NodeRelationFactories;
import com.centreon.studio.client.model.ui.LayoutUtils;
import com.centreon.studio.client.model.ui.actions.common.StudioAction;
import com.centreon.studio.client.model.ui.actions.layout.MoveNodesAction;
import com.centreon.studio.client.model.ui.actions.layout.ResizeNodesAction;
import com.centreon.studio.client.model.ui.dialogs.CustomWizardDialog;
import com.centreon.studio.client.model.ui.dialogs.WizardFactories;
import com.centreon.studio.client.utils.SequenceUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.NonResizableEditPolicy;
import org.eclipse.gef.editpolicies.ResizableEditPolicy;
import org.eclipse.gef.editpolicies.XYLayoutEditPolicy;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.CreateRequest;

public final class NodeLayoutEditPolicy
extends XYLayoutEditPolicy {
    private boolean first;

    private static ListOfPos pointsToPoses(PointList points) {
        ListOfPos pos = new ListOfPos(points.size());
        int i = 0;
        while (i < points.size()) {
            pos.add((Object)Pos.create((double)points.getPoint((int)i).x, (double)points.getPoint((int)i).y));
            ++i;
        }
        return pos;
    }

    public void eraseTargetFeedback(Request request) {
        if (!this.canEditHostModel(request)) {
            return;
        }
        super.eraseTargetFeedback(request);
    }

    public void showTargetFeedback(Request request) {
        if (!this.canEditHostModel(request)) {
            return;
        }
        this.first = true;
        super.showTargetFeedback(request);
    }

    public boolean understandsRequest(Request request) {
        return request.getType().equals("resize children") || request.getType().equals("move children") || request.getType().equals("create child");
    }

    protected Command createChangeConstraintCommand(ChangeBoundsRequest request, EditPart child, Object constraint) {
        if (!this.canEditHostModel((Request)request)) {
            return null;
        }
        if (this.first) {
            this.first = false;
            Object action = request.getType().equals("move children") ? this.createMoveAction(request) : (request.getType().equals("resize children") ? this.createResizeAction(request) : null);
            return new Command((StudioAction)action){
                private final /* synthetic */ StudioAction val$action;
                {
                    this.val$action = studioAction;
                }

                public boolean canExecute() {
                    return this.val$action != null && this.val$action.isEnabled();
                }

                public void execute() {
                    if (this.val$action != null) {
                        this.val$action.run();
                    }
                }
            };
        }
        return YesCommand.getInstance();
    }

    protected EditPolicy createChildEditPolicy(EditPart child) {
        if (child instanceof ANodeRelationGraphicalEditPart && !this.canEditHostModel(null)) {
            return new CustomNonResizableEditPolicy();
        }
        return new ResizableEditPolicy();
    }

    protected Command getCreateCommand(final CreateRequest request) {
        if (!this.canEditHostModel((Request)request)) {
            return null;
        }
        return new Command(){

            public void execute() {
                NodeLayoutEditPolicy.this.create(request);
            }
        };
    }

    private boolean canEditHostModel(Request request) {
        INode parent = ((INodeRelation)this.getHost().getModel()).getTarget();
        if (Boolean.FALSE.equals(parent.getProperty(ACLPropertyDescriptors.CAN_UPDATE))) {
            return false;
        }
        if (request instanceof ContextCreationTool.ContextCreateRequest) {
            ContextCreationTool.ContextCreateRequest create = (ContextCreationTool.ContextCreateRequest)request;
            CustomCreationFactory factory = create.getFactory();
            return TypeHierarchy.isValid((TypeDescriptor)parent.getType(), (TypeDescriptor)factory.getNodeType());
        }
        return true;
    }

    private void create(CreateRequest request) {
        List<INode> nodes;
        Object newObject = request.getNewObject();
        List<INode> list = nodes = newObject instanceof INode ? Arrays.asList((INode)newObject) : (List<INode>)newObject;
        if (nodes == null) {
            return;
        }
        Viewport viewport = (Viewport)((CustomScalableFreeformRootEditPart)this.getHost().getViewer().getRootEditPart()).getFigure();
        Point location = request.getLocation().translate(viewport.getHorizontalRangeModel().getValue(), viewport.getVerticalRangeModel().getValue());
        IEclipseContext context = (IEclipseContext)request.getExtendedData().get(IEclipseContext.class);
        TypeDescriptor relationType = (TypeDescriptor)request.getNewObjectType();
        PointList points = (PointList)request.getExtendedData().get(PointList.class);
        INode parent = ((INodeRelation)this.getHost().getModel()).getTarget();
        Double zoom = LayoutUtils.INSTANCE.getZoom(parent);
        boolean openDialog = context != null && newObject instanceof INode;
        for (INode target : nodes) {
            CustomWizardDialog dialog;
            INodeRelation relation = NodeRelationFactories.INSTANCE.create(relationType, SequenceUtils.next(), parent, target, null);
            Pos minDim = LayoutUtils.INSTANCE.getMinDim(relation);
            Pos dim = request.getSize() == null ? (Pos)target.getProperty(PropertyDescriptors.DIMENSION) : Pos.create((double)request.getSize().width, (double)request.getSize().height).div(zoom.doubleValue());
            Pos dimension = Pos.create((double)Math.max(dim.x, minDim.x), (double)Math.max(dim.y, minDim.y));
            Pos position = Pos.create((double)((double)location.x / zoom + dimension.x / 2.0), (double)((double)location.y / zoom + dimension.y / 2.0));
            ArrayList<PropertyValue> relationProperties = new ArrayList<PropertyValue>(2);
            relationProperties.add(new PropertyValue(PropertyDescriptors.POSITION, (Object)position));
            relationProperties.add(new PropertyValue(PropertyDescriptors.DIMENSION, (Object)dimension));
            relation.addPropertyValues(relationProperties);
            if (points != null) {
                target.addPropertyValue(PropertyDescriptors.POINTS, (Object)NodeLayoutEditPolicy.pointsToPoses(points));
            }
            if (openDialog && (dialog = WizardFactories.INSTANCE.createDialog(relation, context)) != null) {
                dialog.create();
                dialog.getShell().setVisible(true);
                dialog.getShell().setFocus();
                dialog.getShell().forceActive();
                if (dialog.open() != 0) {
                    return;
                }
                relation = (INodeRelation)dialog.getInput().iterator().next();
            }
            parent.addRelation(relation);
        }
    }

    private StudioAction createMoveAction(ChangeBoundsRequest request) {
        Point deltaPoint = request.getMoveDelta();
        INodeRelation model = (INodeRelation)this.getHost().getModel();
        Pos deltaPos = Pos.create((double)deltaPoint.x, (double)deltaPoint.y).div(LayoutUtils.INSTANCE.getZoom(model.getTarget()).doubleValue());
        return new MoveNodesAction(model.getTarget().getRepository(), deltaPos);
    }

    private StudioAction createResizeAction(ChangeBoundsRequest request) {
        Dimension deltaDimension = request.getSizeDelta();
        INodeRelation model = (INodeRelation)this.getHost().getModel();
        Pos deltaPos = Pos.create((double)deltaDimension.width, (double)deltaDimension.height).div(LayoutUtils.INSTANCE.getZoom(model.getTarget()).doubleValue());
        return new ResizeNodesAction(model.getTarget().getRepository(), deltaPos, request.getResizeDirection());
    }

    private static class CustomNonResizableEditPolicy
    extends NonResizableEditPolicy {
        private CustomNonResizableEditPolicy() {
        }

        protected void createDragHandle(List handles, int direction) {
        }

        protected List<?> createSelectionHandles() {
            return Collections.emptyList();
        }
    }
}

