/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.gef.editpolicies;

import com.centreon.studio.client.model.relation.INodeRelation;
import com.centreon.studio.client.model.ui.tooltips.TooltipManager;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.gef.Request;
import org.eclipse.gef.editpolicies.AbstractEditPolicy;

public final class NodeTooltipEditPolicy
extends AbstractEditPolicy {
    private final INodeRelation relation;

    public NodeTooltipEditPolicy(INodeRelation relation) {
        this.relation = relation;
    }

    public void eraseTargetFeedback(Request request) {
        if (this.understandsRequest(request) && TooltipManager.INSTANCE.isTooltipDisplayed()) {
            TooltipManager.INSTANCE.removeTooltip();
        }
    }

    public void showTargetFeedback(Request request) {
        String tooltipActiveProperty = (String)this.getHost().getViewer().getProperty("tooltipActive");
        boolean tooltipActive = Boolean.parseBoolean(tooltipActiveProperty);
        if (!tooltipActive) {
            return;
        }
        if (this.understandsRequest(request)) {
            if (TooltipManager.INSTANCE.isTooltipDisplayed()) {
                TooltipManager.INSTANCE.updateTooltipLocation();
            } else {
                IEclipseContext context = (IEclipseContext)this.getHost().getViewer().getProperty(IEclipseContext.class.getSimpleName());
                TooltipManager.INSTANCE.displayTooltip(this.relation, context);
            }
        }
    }

    public boolean understandsRequest(Request request) {
        return "selection".equals(request.getType()) || "selection hover".equals(request.getType());
    }
}

