/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.gef.palette;

import com.centreon.studio.client.gef.palette.CustomCreationFactory;
import java.util.Map;
import org.eclipse.draw2d.Cursors;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gef.requests.CreationFactory;
import org.eclipse.gef.tools.CreationTool;

public class ContextCreationTool
extends CreationTool {
    private IEclipseContext context;
    private String toolLabel;

    public ContextCreationTool() {
        this.setDefaultCursor(Cursors.CROSS);
    }

    public String getToolLabel() {
        return this.toolLabel;
    }

    public void setFactory(CreationFactory factory) {
        if (factory instanceof CustomCreationFactory) {
            this.toolLabel = ((CustomCreationFactory)factory).getCreationToolLabel();
        }
        super.setFactory(factory);
    }

    protected void applyProperty(Object key, Object value) {
        if (key == IEclipseContext.class) {
            this.context = (IEclipseContext)value;
        } else {
            super.applyProperty(key, value);
        }
    }

    protected Request createTargetRequest() {
        ContextCreateRequest request = new ContextCreateRequest(this.context);
        request.setFactory(this.getFactory());
        return request;
    }

    protected void enforceConstraintsForSizeOnDropCreate(CreateRequest request) {
        if (this.getTargetEditPart() == null || ((GraphicalEditPart)this.getTargetEditPart()).getContentPane() == null) {
            return;
        }
        super.enforceConstraintsForSizeOnDropCreate(request);
    }

    public static class ContextCreateRequest
    extends CreateRequest {
        private final IEclipseContext context;

        private ContextCreateRequest(IEclipseContext context) {
            this.context = context;
        }

        public Map getExtendedData() {
            Map map = super.getExtendedData();
            map.put(IEclipseContext.class, this.context);
            return map;
        }

        public CustomCreationFactory getFactory() {
            return (CustomCreationFactory)super.getFactory();
        }
    }
}

