/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.gef.palette;

import com.centreon.studio.client.events.BrokerEventManager;
import com.centreon.studio.client.events.StudioEvent;
import com.centreon.studio.client.events.exception.ExceptionEvent;
import com.centreon.studio.client.gef.palette.CreationTool;
import com.centreon.studio.client.gef.palette.CustomCreationFactory;
import com.centreon.studio.client.model.relation.INodeRelation;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.gef.Tool;
import org.eclipse.gef.palette.ToolEntry;
import org.eclipse.gef.requests.CreationFactory;
import org.eclipse.gef.tools.AbstractTool;
import org.eclipse.jface.resource.ImageDescriptor;

public class ContextCreationToolEntry
extends ToolEntry {
    private ImageDescriptor smallIcon;
    private final INodeRelation relation;
    private CreationFactory factory;

    public ContextCreationToolEntry(String label, CreationFactory factory, IEclipseContext context, Class<? extends Tool> clazz, String smallIconPath, Boolean unload) {
        this(label, label, factory, context, clazz, smallIconPath, unload, null);
    }

    public ContextCreationToolEntry(String label, String shortDesc, CreationFactory factory, IEclipseContext context, Class<? extends Tool> clazz, String smallIconPath, Boolean unload, INodeRelation relation) {
        super(label, shortDesc, null, null, clazz);
        this.setToolProperty(IEclipseContext.class, context);
        this.setToolProperty(org.eclipse.gef.tools.CreationTool.PROPERTY_CREATION_FACTORY, factory);
        this.setToolProperty(AbstractTool.PROPERTY_UNLOAD_WHEN_FINISHED, unload);
        this.relation = relation;
        this.factory = factory;
        BrokerEventManager eventManager = (BrokerEventManager)ContextInjectionFactory.make(BrokerEventManager.class, (IEclipseContext)context);
        try {
            this.smallIcon = ImageDescriptor.createFromURL((URL)new URL(smallIconPath));
        }
        catch (MalformedURLException e) {
            eventManager.async((StudioEvent)new ExceptionEvent((Throwable)e));
        }
    }

    public String getToolLabel() {
        if (this.factory instanceof CustomCreationFactory) {
            return ((CustomCreationFactory)this.factory).getCreationToolLabel();
        }
        return CreationTool.LINK_TEMPLATE.label;
    }

    public String getLabel() {
        if (this.relation != null) {
            return this.relation.getTarget().getLabel();
        }
        return super.getLabel();
    }

    public ImageDescriptor getLargeIcon() {
        return this.getSmallIcon();
    }

    public INodeRelation getRelation() {
        return this.relation;
    }

    public ImageDescriptor getSmallIcon() {
        return this.smallIcon;
    }
}

