/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.utils;

import com.centreon.studio.client.utils.HashedArrayList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class CollectionsUtils {
    private static final boolean USE_JDK8_COLLECTIONS = CollectionsUtils.useJD8Collections();

    public static final <T> List<T> createList(int initialCapacity) {
        return new HashedArrayList(initialCapacity);
    }

    public static final <K, V> Map<K, V> createMap(int initialCapacity, V defaultValue) {
        if (defaultValue == null) {
            return new HashMap(initialCapacity);
        }
        return new DefaultValueHashMap(initialCapacity, defaultValue);
    }

    public static final <K, V, C extends Collection<V>> Map<K, C> createMultiMap(int initialCapacity, Class<C> defaultValue) {
        if (defaultValue == null) {
            return new HashMap(initialCapacity);
        }
        return new MultiMap(initialCapacity, defaultValue);
    }

    public static <T> void sort(List<T> list, Comparator<T> c) {
        Collections.sort(list, c);
        if (USE_JDK8_COLLECTIONS && list instanceof HashedArrayList) {
            ((HashedArrayList)list).reindex(0);
        }
    }

    public static <T> List<List<T>> sub(List<T> list, int size) {
        if (list == null || list.isEmpty()) {
            return Collections.emptyList();
        }
        if (size < 1) {
            return Arrays.asList(list);
        }
        int number = list.size();
        ArrayList<List<T>> subs = new ArrayList<List<T>>(number);
        int i = 0;
        while (i < number) {
            subs.add(list.subList(i, Math.min(i + size, list.size())));
            i += size;
        }
        return subs;
    }

    private static final boolean useJD8Collections() {
        try {
            List.class.getMethod("sort", Comparator.class);
            return true;
        }
        catch (NoSuchMethodException | SecurityException exception) {
            return false;
        }
    }

    private CollectionsUtils() {
    }

    private static final class DefaultValueHashMap<K, V>
    extends HashMap<K, V> {
        private static final long serialVersionUID = -7385206508585886243L;
        private final V defaultValue;

        private DefaultValueHashMap(int size, V defaultValue) {
            super(size);
            this.defaultValue = defaultValue;
        }

        @Override
        public V get(Object key) {
            Object value = super.get(key);
            if (value == null) {
                return this.defaultValue;
            }
            return value;
        }

        @Override
        public V put(K key, V value) {
            if (value == null || value == this.defaultValue) {
                return this.remove(key);
            }
            return super.put(key, value);
        }
    }

    private static final class MultiMap<K, V, C extends Collection<V>>
    extends HashMap<K, C> {
        private static final long serialVersionUID = 1487441087581756017L;
        private final Class<C> clazz;

        private MultiMap(int size, Class<C> clazz) {
            super(size);
            this.clazz = clazz;
        }

        @Override
        public C get(Object key) {
            Collection value = (Collection)super.get(key);
            if (value == null) {
                try {
                    value = (Collection)this.clazz.newInstance();
                    this.put(key, value);
                }
                catch (IllegalAccessException | InstantiationException e) {
                    e.printStackTrace();
                }
            }
            return (C)value;
        }

        @Override
        public void putAll(Map<? extends K, ? extends C> m) {
            Iterator<Map.Entry<K, C>> iterator = m.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<K, C> entry = iterator.next();
                Collection value = (Collection)super.get(entry.getKey());
                if (value == null) continue;
                value.addAll((Collection)entry.getValue());
                iterator.remove();
            }
            super.putAll(m);
        }
    }
}

