/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.utils;

import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;

public class DateUtils {
    public static String formatTimeInterval(LocalDateTime startDate, LocalDateTime endDate) {
        if (startDate == null || endDate == null) {
            throw new IllegalArgumentException("Supplied dates must not be null. Given dates " + startDate + endDate);
        }
        if (startDate.isAfter(endDate)) {
            throw new IllegalArgumentException("Supplied oldest date is younger. Given dates " + startDate + endDate);
        }
        LocalDateTime timeBuffer = LocalDateTime.from(startDate);
        long years = ChronoUnit.YEARS.between(timeBuffer, endDate);
        timeBuffer = timeBuffer.plusYears(years);
        long months = ChronoUnit.MONTHS.between(timeBuffer, endDate);
        timeBuffer = timeBuffer.plusMonths(months);
        long weeks = ChronoUnit.WEEKS.between(timeBuffer, endDate);
        timeBuffer = timeBuffer.plusWeeks(weeks);
        long days = ChronoUnit.DAYS.between(timeBuffer, endDate);
        timeBuffer = timeBuffer.plusDays(days);
        long hours = ChronoUnit.HOURS.between(timeBuffer, endDate);
        timeBuffer = timeBuffer.plusHours(hours);
        long minutes = ChronoUnit.MINUTES.between(timeBuffer, endDate);
        timeBuffer = timeBuffer.plusMinutes(minutes);
        long seconds = ChronoUnit.SECONDS.between(timeBuffer, endDate);
        if (years != 0L) {
            return String.valueOf(years) + TimeUnit.YEARS.symbol + (months != 0L ? " " + months + TimeUnit.MONTHS.symbol : (weeks != 0L ? " " + weeks + TimeUnit.WEEKS.symbol : ""));
        }
        if (months != 0L) {
            return String.valueOf(months) + TimeUnit.MONTHS.symbol + (weeks != 0L ? " " + weeks + TimeUnit.WEEKS.symbol : (days != 0L ? " " + days + TimeUnit.DAYS.symbol : ""));
        }
        if (weeks != 0L) {
            return String.valueOf(weeks) + TimeUnit.WEEKS.symbol + (days != 0L ? " " + days + TimeUnit.DAYS.symbol : (hours != 0L ? " " + hours + TimeUnit.HOURS.symbol : ""));
        }
        if (days != 0L) {
            return String.valueOf(days) + TimeUnit.DAYS.symbol + (hours != 0L ? " " + hours + TimeUnit.HOURS.symbol : (minutes != 0L ? " " + minutes + TimeUnit.MINUTES.symbol : ""));
        }
        if (hours != 0L) {
            return String.valueOf(hours) + TimeUnit.HOURS.symbol + (minutes != 0L ? " " + minutes + TimeUnit.MINUTES.symbol : (seconds != 0L ? " " + seconds + TimeUnit.SECONDS.symbol : ""));
        }
        if (minutes != 0L) {
            return String.valueOf(minutes) + TimeUnit.MINUTES.symbol + (seconds != 0L ? " " + seconds + TimeUnit.SECONDS.symbol : "");
        }
        return String.valueOf(seconds) + TimeUnit.SECONDS.symbol;
    }

    private static enum TimeUnit {
        YEARS("Y"),
        MONTHS("M"),
        WEEKS("W"),
        DAYS("D"),
        HOURS("h"),
        MINUTES("m"),
        SECONDS("s");

        private final String symbol;

        private TimeUnit(String symbol) {
            this.symbol = symbol;
        }
    }
}

