/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.utils;

public final class HexUtils {
    private static final char[] K_HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static String bufferToHex(byte[] buffer) {
        return HexUtils.bufferToHex(buffer, 0, buffer.length);
    }

    public static byte[] hexToBuffer(String hex) {
        byte[] bytes = new byte[hex.length() / 2];
        int i = 0;
        while (i < hex.length() - 1) {
            String output = hex.substring(i, i + 2);
            bytes[i / 2] = (byte)Integer.parseInt(output, 16);
            i += 2;
        }
        return bytes;
    }

    private static void appendHexPair(byte b, StringBuilder hexString) {
        char highNibble = K_HEX_CHARS[(b & 0xF0) >> 4];
        char lowNibble = K_HEX_CHARS[b & 0xF];
        hexString.append(highNibble);
        hexString.append(lowNibble);
    }

    private static String bufferToHex(byte[] buffer, int startOffset, int length) {
        StringBuilder hexString = new StringBuilder(2 * length);
        int endOffset = startOffset + length;
        int i = startOffset;
        while (i < endOffset) {
            HexUtils.appendHexPair(buffer[i], hexString);
            ++i;
        }
        return hexString.toString();
    }

    private HexUtils() {
    }
}

