/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.utils;

import java.nio.charset.Charset;
import java.text.DecimalFormat;
import org.apache.commons.lang3.math.NumberUtils;

public final class StringUtils {
    public static final Charset CHARSET = Charset.forName("UTF-8");
    public static final String NEW_LINE = System.getProperty("line.separator");
    public static final String EMPTY_STRING = "";
    public static final String SLASH = "/";
    public static final String COMMA = ",";
    public static final String SPACE = " ";
    public static final String EQUAL = "=";
    public static final String SHARP = "#";
    public static final String COLON = ":";
    public static final String SEMICOLON = ";";
    public static final String AND = "&";
    public static final String PERCENT = "%";
    public static final String PAROPE = "(";
    public static final String PARCLO = ")";
    public static final String DASH = "-";
    public static final String DOT = ".";
    public static final String AT = "@";
    public static final String SEPARATOR = " - ";
    private static final DecimalFormat SIX_DIGIT_DECIMAL_FORMAT = new DecimalFormat("#.######");
    private static final DecimalFormat ONE_DIGIT_DECIMAL_FORMAT = new DecimalFormat("#");

    public static String alphaNumeric(String string) {
        return string.replaceAll("[^A-Za-z0-9.]", EMPTY_STRING);
    }

    public static int count(String input, String pattern) {
        int i = 0;
        int cursor = 0;
        while ((cursor = input.indexOf(pattern, cursor + 1)) != -1) {
            ++i;
        }
        return i;
    }

    public static String firstNotNullEmptyOrBlank(String ... values) {
        String[] stringArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            String value = stringArray[n2];
            if (!StringUtils.isNullEmptyOrBlank(value)) {
                return value;
            }
            ++n2;
        }
        return null;
    }

    public static String format(Double number) {
        return StringUtils.format(number, false);
    }

    public static String format(Double number, boolean shortFormat) {
        DecimalFormat formatter;
        if (number == null) {
            return null;
        }
        DecimalFormat decimalFormat = formatter = shortFormat ? ONE_DIGIT_DECIMAL_FORMAT : SIX_DIGIT_DECIMAL_FORMAT;
        if (number == Double.MIN_VALUE) {
            return formatter.format(Double.NEGATIVE_INFINITY);
        }
        if (number == Double.MAX_VALUE) {
            return formatter.format(Double.POSITIVE_INFINITY);
        }
        return formatter.format(number);
    }

    public static boolean isAllNullEmptyOrBlank(String ... args) {
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            if (!StringUtils.isNullEmptyOrBlank(arg)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static boolean isNullEmptyOrBlank(String string) {
        if (string == null) {
            return true;
        }
        if (string.length() == 0) {
            return true;
        }
        if (string.trim().length() == 0) {
            return true;
        }
        return "null".equalsIgnoreCase(string.trim());
    }

    public static boolean isNumber(String input) {
        return NumberUtils.isCreatable((String)input);
    }

    public static boolean isOneNullEmptyOrBlank(String ... args) {
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            if (StringUtils.isNullEmptyOrBlank(arg)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static double parseDouble(String input, double errorValue) {
        if (NumberUtils.isCreatable((String)input)) {
            Number number = NumberUtils.createNumber((String)input);
            return number.doubleValue();
        }
        return errorValue;
    }

    public static int parseInt(String input) {
        return StringUtils.parseInt(input, Integer.MIN_VALUE);
    }

    public static int parseInt(String input, int errorValue) {
        if (NumberUtils.isCreatable((String)input)) {
            Number number = NumberUtils.createNumber((String)input);
            return number.intValue();
        }
        return errorValue;
    }

    public static long parseLong(String input, long errorValue) {
        if (NumberUtils.isCreatable((String)input)) {
            Number number = NumberUtils.createNumber((String)input);
            return number.longValue();
        }
        return errorValue;
    }

    public static String toHex(int value, int length) {
        String hex = Integer.toHexString(value);
        while (hex.length() < length) {
            hex = String.valueOf('0') + hex;
        }
        return hex;
    }

    private StringUtils() {
    }
}

