/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.map.client.importmap3;

import com.centreon.studio.client.acl.ACLUser;
import com.centreon.studio.client.commons.ContextUtils;
import com.centreon.studio.client.events.BrokerEventManager;
import com.centreon.studio.client.events.StudioEvent;
import com.centreon.studio.client.events.StudioEventHandler;
import com.centreon.studio.client.events.auth.AuthenticationEventHandler;
import com.centreon.studio.client.events.exception.ExceptionEvent;
import com.centreon.studio.client.events.log.LogEvent;
import com.centreon.studio.client.model.repository.IRepository;
import com.centreon.studio.client.model.ui.actions.common.SeparatorAction;
import com.centreon.studio.client.model.ui.actions.common.StudioAction;
import com.centreon.studio.client.model.ui.actionsets.ActionSetContributor;
import com.centreon.studio.client.model.ui.actionsets.ActionSetDescriptor;
import com.centreon.studio.map.client.gates.model.GateRepositoryDecorator;
import com.centreon.studio.map.client.gates.ui.GateActionSetDescriptor;
import com.centreon.studio.map.client.importmap3.ImportMap3Action;
import com.centreon.studio.map.client.importmap3.extractor.Extractor;
import com.centreon.studio.map.client.importmap3.messages.ImportMap3Messages;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;

public class ImportMap3Addon
extends AuthenticationEventHandler
implements ActionSetContributor {
    private static String GEOLOC_IMPORT_TROUBLESHOOTER = "https://documentation.centreon.com/docs/centreon-map-4/en/latest/troubleshooter/index.html#an-error-occured-when-i-open-a-geographic-view";
    private final IEclipseContext context;
    private final BrokerEventManager eventManager;

    @Inject
    public ImportMap3Addon(IEclipseContext context, BrokerEventManager eventManager) {
        this.eventManager = eventManager;
        this.context = context;
    }

    public void contribute(List<StudioAction> actions, IEclipseContext context) {
        IRepository input = (IRepository)ContextInjectionFactory.make(GateRepositoryDecorator.class, (IEclipseContext)context);
        actions.add(actions.size() - 2, (StudioAction)SeparatorAction.INSTANCE);
        actions.add(actions.size() - 2, (StudioAction)new ImportMap3Action(input, context));
        actions.add(actions.size() - 2, (StudioAction)SeparatorAction.INSTANCE);
    }

    @PostConstruct
    public void postConstruct(BrokerEventManager eventManager) {
        eventManager.subscribe("studio/authentication", true, (StudioEventHandler)this);
        eventManager.async((StudioEvent)ExceptionEvent.registerException((String)ImportMap3Messages.geolocViewErrorPopup, (String)GEOLOC_IMPORT_TROUBLESHOOTER));
        eventManager.async((StudioEvent)LogEvent.trace(((Object)((Object)this)).getClass(), (String)"Import Map 3 addon loaded", (Object[])new Object[0]));
    }

    @PreDestroy
    public void preDestroy(BrokerEventManager eventManager) {
        eventManager.unsubscribe((StudioEventHandler)this);
        eventManager.async((StudioEvent)LogEvent.trace(((Object)((Object)this)).getClass(), (String)"Import Map 3 addon destroyed", (Object[])new Object[0]));
    }

    protected void loggedIn() {
        block2: {
            try {
                ACLUser user = (ACLUser)ContextUtils.getTopContext((IEclipseContext)this.context).get(ACLUser.class);
                Extractor.authenticate(user);
                ActionSetDescriptor.contribute(GateActionSetDescriptor.class, (ActionSetContributor)this);
            }
            catch (Exception e) {
                if (!LogEvent.LOG_LEVEL.shouldLog(LogEvent.LogLevel.TRACE)) break block2;
                this.eventManager.async((StudioEvent)new ExceptionEvent((Throwable)e));
            }
        }
    }

    protected void loggedOut() {
        ActionSetDescriptor.uncontribute(GateActionSetDescriptor.class, (ActionSetContributor)this);
    }
}

