/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.map.client.importmap3.extractor;

import com.centreon.studio.map.client.importmap3.extractor.XmlUtilities;
import com.centreon.studio.map.client.importmap3.map3.model.authentication.CSIdentity;
import com.centreon.studio.map.client.importmap3.map3.model.authentication.CSIdentityFactory;
import com.centreon.studio.map.client.importmap3.map3.model.authentication.CSProfile;
import com.centreon.studio.map.client.importmap3.map3.model.authentication.CSServer;
import com.centreon.studio.map.client.importmap3.map3.model.authentication.MapX509TrustManager;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.security.SecureRandom;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.input.SAXBuilder;

public class APIUtils {
    private static final String PROTOCOL_HTTP = "http://";
    private static final String PROTOCOL_HTTPS = "https://";
    private static final String URL_SUFFIX = "modules/centreon-map-server/webServices/portal.php";
    private static final String ENCODING_DEFLATE = "deflate";
    private static final String ENCODING_GZIP = "gzip";
    public static final String REQ_TYPE_VIEW = "view";
    public static final String REQ_TYPE_TREE = "tree";
    public static final String REQ_TYPE_LINK = "link";
    public static final String REQ_TYPE_LINKLIB = "linklib";
    public static final String REQ_TYPE_RESOURCE = "resource";
    public static final String REQ_TYPE_GEO = "geo";
    public static final String REQ_ACTION_UPDATE = "update";
    public static final String REQ_ACTION_LIST = "list";
    public static final String REQ_ACTION_IMAGE = "image";
    public static final String ANSWER = "answer";
    private static final int CONNEXION_TIMEOUT = 60000;
    private static final int READ_TIMEOUT = 60000;

    public static HttpURLConnection buildConnection(CSServer server) throws Exception {
        String path = server.isUseSecureConnexion() ? PROTOCOL_HTTPS : PROTOCOL_HTTP;
        String address = server.getAddress();
        if (address.endsWith("/")) {
            address = address.substring(0, server.getAddress().length() - 1);
        }
        String urlPath = server.getUrl().startsWith("/") ? server.getUrl() : "/" + server.getUrl();
        path = String.valueOf(path) + address + ":" + server.getPort() + urlPath;
        path = String.valueOf(path) + URL_SUFFIX;
        if (server.isUseSecureConnexion()) {
            APIUtils.setHttpsSetting(server);
        }
        URL url = new URL(path);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setConnectTimeout(60000);
        connection.setReadTimeout(60000);
        connection.setDoOutput(true);
        return connection;
    }

    public static Document executeRequest(URLConnection connection, Document req) throws Exception {
        Throwable throwable = null;
        Object var3_4 = null;
        try {
            OutputStream connectionOutputStream = connection.getOutputStream();
            XmlUtilities.OUTPUTTER.output(req, connectionOutputStream);
            connectionOutputStream.flush();
            InputStream input = null;
            Document document = null;
            String encoding = connection.getContentEncoding();
            input = ENCODING_GZIP.equalsIgnoreCase(encoding) ? new GZIPInputStream(connection.getInputStream()) : (ENCODING_DEFLATE.equalsIgnoreCase(encoding) ? new InflaterInputStream(connection.getInputStream(), new Inflater(true)) : connection.getInputStream());
            SAXBuilder sxb = new SAXBuilder();
            Document document2 = document = sxb.build(input);
            return document2;
            {
                finally {
                    if (input != null) {
                        input.close();
                    }
                    connectionOutputStream.close();
                }
            }
            finally {
                if (connectionOutputStream != null) {
                    connectionOutputStream.close();
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static Document forgeRequest(String userId, String sessionId, String type, String action, Map<String, String> parameters) {
        Document document = new Document();
        Element data = new Element("value");
        Element header = new Element("header");
        Element module = new Element("module");
        module.setAttribute("name", "centreon-map");
        module.setAttribute("version", "3.8.1");
        header.addContent((Content)module);
        Element user = new Element("user");
        user.setAttribute("id", userId);
        user.setAttribute("session", sessionId);
        header.addContent((Content)user);
        data.addContent((Content)header);
        Element request = new Element("request");
        request.setAttribute("type", type);
        request.setAttribute("action", action);
        request.setAttribute("view_id", "-1");
        if (parameters != null) {
            for (Map.Entry<String, String> entry : parameters.entrySet()) {
                request.setAttribute(entry.getKey(), entry.getValue());
            }
        }
        data.addContent((Content)request);
        document.setRootElement(data);
        return document;
    }

    public static CSIdentity login(CSProfile profile) throws Exception {
        if (profile == null) {
            return null;
        }
        HttpURLConnection connection = APIUtils.buildConnection(profile.getServer());
        Document request = APIUtils.forgeLoginRequest(profile.getLogin(), profile.getPassword());
        Document data = APIUtils.executeRequest(connection, request);
        return CSIdentityFactory.create(data);
    }

    private static Document forgeLoginRequest(String login, String password) {
        Document document = new Document();
        Element data = new Element("value");
        Element header = new Element("header");
        Element identify = new Element("identity");
        identify.setAttribute("user_name", login);
        identify.setAttribute("user_password", password);
        header.addContent((Content)identify);
        Element module = new Element("module");
        module.setAttribute("name", "centreon-map");
        module.setAttribute("version", "3.8.1");
        header.addContent((Content)module);
        data.addContent((Content)header);
        document.setRootElement(data);
        return document;
    }

    private static synchronized void setHttpsSetting(CSServer server) throws Exception {
        SSLContext sc = SSLContext.getInstance("SSL");
        TrustManager[] myTMs = new TrustManager[]{new MapX509TrustManager(server)};
        sc.init(null, myTMs, new SecureRandom());
        HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
        HttpsURLConnection.setDefaultHostnameVerifier((a, b) -> true);
    }

    private APIUtils() {
    }
}

