/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.map.client.importmap3.extractor;

import com.centreon.studio.client.acl.ACLUser;
import com.centreon.studio.client.authentication.model.AuthenticationPropertyDescriptors;
import com.centreon.studio.client.events.BrokerEventManager;
import com.centreon.studio.client.events.StudioEvent;
import com.centreon.studio.client.events.exception.ExceptionEvent;
import com.centreon.studio.client.model.property.PropertyDescriptors;
import com.centreon.studio.client.utils.StringUtils;
import com.centreon.studio.map.client.elements.geo.model.GeoPropertyDescriptors;
import com.centreon.studio.map.client.importmap3.ImportMap3Exception;
import com.centreon.studio.map.client.importmap3.extractor.APIUtils;
import com.centreon.studio.map.client.importmap3.extractor.Parser;
import com.centreon.studio.map.client.importmap3.extractor.model.map3.Container;
import com.centreon.studio.map.client.importmap3.extractor.model.map3.Link;
import com.centreon.studio.map.client.importmap3.map3.model.authentication.CSIdentity;
import com.centreon.studio.map.client.importmap3.map3.model.authentication.CSProfile;
import com.centreon.studio.map.client.importmap3.map3.model.authentication.CSServer;
import com.centreon.studio.map.client.importmap3.messages.ImportMap3Messages;
import java.net.HttpURLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom2.Document;
import org.jdom2.Element;

public class Extractor {
    private static final Map<Long, Container> VIEWS = new HashMap<Long, Container>(20);
    private static CSServer server;
    private static CSIdentity identity;
    private final Map<Long, Container> ctnMap = new HashMap<Long, Container>(1000);
    private final Map<Long, List<Long>> ctnRelations = new HashMap<Long, List<Long>>(1000);
    private final Map<Long, Link> links = new HashMap<Long, Link>(10);
    private final Map<Long, Link> linkTemplates = new HashMap<Long, Link>(10);
    private final Map<Long, String> idToMediaName = new HashMap<Long, String>(100);
    private final Map<Long, String> hostToLatlng = new HashMap<Long, String>(100);
    private final BrokerEventManager eventManager;
    private final Parser parser = new Parser(this);
    private Long currentGateId;

    public static void authenticate(ACLUser user) throws Exception {
        String password = (String)user.getProperty(AuthenticationPropertyDescriptors.PWD);
        String login = (String)user.getProperty(AuthenticationPropertyDescriptors.LOGIN);
        String address = (String)user.getProperty(PropertyDescriptors.ADDRESS);
        boolean useSecureConnexion = address.startsWith("https");
        String subAddress = useSecureConnexion ? address.substring(8) : address.substring(7);
        subAddress = subAddress.endsWith("/centreon") ? subAddress.substring(0, subAddress.length() - 9) : subAddress;
        int port = useSecureConnexion ? 443 : 80;
        server = new CSServer("Central", subAddress, port, "/centreon/", useSecureConnexion);
        identity = APIUtils.login(new CSProfile(server, login, password));
    }

    public Extractor(BrokerEventManager eventManager) {
        this.eventManager = eventManager;
    }

    public void addContainer(Container container) {
        this.ctnMap.put(container.getId(), container);
    }

    public void addCtnRelation(long source, long target) {
        List<Long> targets = this.ctnRelations.get(source);
        if (targets == null) {
            targets = new ArrayList<Long>(10);
            this.ctnRelations.put(source, targets);
        }
        targets.add(target);
    }

    public void addHostToLatLng(Long hostId, String latlng) {
        this.hostToLatlng.put(hostId, latlng);
    }

    public void extractContainer(Long viewId) throws ImportMap3Exception {
        this.currentGateId = viewId;
        Container c = this.getCurrentView();
        if (Boolean.parseBoolean(c.getPropertyValue(GeoPropertyDescriptors.IS_GEO.id)) && StringUtils.isAllNullEmptyOrBlank((String[])new String[]{System.getProperty(GeoPropertyDescriptors.MAPBOX_TOKEN.id)})) {
            throw new ImportMap3Exception(ImportMap3Messages.geolocViewErrorPopup);
        }
        HashMap<String, String> parameters = new HashMap<String, String>(1);
        parameters.put("view_id", viewId.toString());
        Document doc = APIUtils.forgeRequest(identity.getUserId(), identity.getSessionId(), "tree", "list", parameters);
        try {
            HttpURLConnection connection = APIUtils.buildConnection(server);
            Document response = APIUtils.executeRequest(connection, doc);
            Element root = response.getRootElement();
            Element answer = root.getChild("answer");
            if (answer == null) {
                return;
            }
            this.parser.parseElement(answer);
        }
        catch (ImportMap3Exception e) {
            throw e;
        }
        catch (Exception e) {
            this.eventManager.async((StudioEvent)new ExceptionEvent((Throwable)e));
        }
    }

    public void extractGeoCoords(Long viewId) throws ImportMap3Exception {
        HashMap<String, String> parameters = new HashMap<String, String>(1);
        parameters.put("view_id", viewId.toString());
        Document doc = APIUtils.forgeRequest(identity.getUserId(), identity.getSessionId(), "geo", "update", parameters);
        try {
            HttpURLConnection connection = APIUtils.buildConnection(server);
            Document response = APIUtils.executeRequest(connection, doc);
            Element root = response.getRootElement();
            Element answer = root.getChild("answer");
            if (answer == null) {
                return;
            }
            this.parser.parseElement(answer);
        }
        catch (ImportMap3Exception e) {
            throw e;
        }
        catch (Exception e) {
            this.eventManager.async((StudioEvent)new ExceptionEvent((Throwable)e));
        }
    }

    public void extractLinks(Long viewId) {
        HashMap<String, String> parameters = new HashMap<String, String>(1);
        parameters.put("view_id", viewId.toString());
        Document doc = APIUtils.forgeRequest(identity.getUserId(), identity.getSessionId(), "link", "list", parameters);
        try {
            HttpURLConnection connection = APIUtils.buildConnection(server);
            Document response = APIUtils.executeRequest(connection, doc);
            Element root = response.getRootElement();
            Element answer = root.getChild("answer");
            if (answer == null) {
                return;
            }
            for (Link link : this.parser.parseLinks(answer)) {
                this.links.put(link.getId(), link);
            }
        }
        catch (Exception e) {
            this.eventManager.async((StudioEvent)new ExceptionEvent((Throwable)e));
        }
    }

    public void extractLinkTemplates(Long viewId) {
        HashMap<String, String> parameters = new HashMap<String, String>(1);
        parameters.put("view_id", viewId.toString());
        Document doc = APIUtils.forgeRequest(identity.getUserId(), identity.getSessionId(), "linklib", "list", parameters);
        try {
            HttpURLConnection connection = APIUtils.buildConnection(server);
            Document response = APIUtils.executeRequest(connection, doc);
            Element root = response.getRootElement();
            Element answer = root.getChild("answer");
            if (answer == null) {
                return;
            }
            for (Link link : this.parser.parseLinks(answer)) {
                this.linkTemplates.put(link.getId(), link);
            }
        }
        catch (Exception e) {
            this.eventManager.async((StudioEvent)new ExceptionEvent((Throwable)e));
        }
    }

    public void extractMediaName(Long viewId) {
        HashMap<String, String> parameters = new HashMap<String, String>(1);
        parameters.put("view_id", viewId.toString());
        Document doc = APIUtils.forgeRequest(identity.getUserId(), identity.getSessionId(), "resource", "image", parameters);
        try {
            HttpURLConnection connection = APIUtils.buildConnection(server);
            Document response = APIUtils.executeRequest(connection, doc);
            Element root = response.getRootElement();
            Element answer = root.getChild("answer");
            if (answer == null) {
                return;
            }
            Element resource = answer.getChild("resource");
            Element child = resource.getChild("images");
            if (child != null) {
                for (Element ctn : child.getChildren()) {
                    this.idToMediaName.put(ctn.getAttribute("res_id").getLongValue(), ctn.getAttributeValue("name"));
                }
            }
        }
        catch (Exception e) {
            this.eventManager.async((StudioEvent)new ExceptionEvent((Throwable)e));
        }
    }

    public Container getContainer(Long ctnId) {
        return this.ctnMap.get(ctnId);
    }

    public Map<Long, List<Long>> getCtnRelations() {
        return Collections.unmodifiableMap(this.ctnRelations);
    }

    public Container getCurrentView() {
        return VIEWS.get(this.currentGateId);
    }

    public String getImageNameFromId(Long id) {
        return this.idToMediaName.get(id);
    }

    public String getLatLng(Long hostId) {
        return this.hostToLatlng.get(hostId);
    }

    public Map<Long, Link> getLinks() {
        return Collections.unmodifiableMap(this.links);
    }

    public Map<Long, Link> getLinkTemplates() {
        return Collections.unmodifiableMap(this.linkTemplates);
    }

    public Map<Long, Container> getViews() {
        return VIEWS;
    }

    public void requestViewList() {
        String userId = identity.getUserId();
        String sessionId = identity.getSessionId();
        Document doc = APIUtils.forgeRequest(userId, sessionId, "view", "list", null);
        try {
            HttpURLConnection connection = APIUtils.buildConnection(server);
            Document response = APIUtils.executeRequest(connection, doc);
            Element root = response.getRootElement();
            Element answer = root.getChild("answer");
            for (Container ctn : this.parser.parseViews(answer)) {
                VIEWS.put(ctn.getId(), ctn);
            }
        }
        catch (Exception e) {
            this.eventManager.async((StudioEvent)new ExceptionEvent((Throwable)e));
        }
    }
}

