/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.map.client.importmap3.map3.model.authentication;

import com.centreon.studio.map.client.importmap3.map3.model.authentication.CSIdentity;
import org.jdom2.Document;
import org.jdom2.Element;

public class CSIdentityFactory {
    public static CSIdentity create(Document document) throws Exception {
        CSIdentity identity = new CSIdentity();
        CSIdentityFactory.parseElement(document.getRootElement(), identity);
        return identity;
    }

    private static void handleErrorElement(Element element) throws Exception {
        int code = Integer.parseInt(element.getAttributeValue("code"));
        if (code == 0) {
            code = 1;
        }
        throw new Exception("Error");
    }

    private static void parseElement(Element element, CSIdentity identity) throws Exception {
        if (element.getName().equalsIgnoreCase("ident")) {
            identity.setSessionId(element.getAttributeValue("token_id"));
            identity.setUserId(element.getAttributeValue("user_id"));
            identity.setExpire(element.getAttributeValue("expires"));
            identity.setSlot(element.getAttributeValue("slot"));
            identity.setSuperAdmin(Boolean.parseBoolean(element.getAttributeValue("super")));
        } else if (element.getName().equalsIgnoreCase("version")) {
            identity.setVersionCentreon(element.getAttributeValue("centreon"));
            identity.setVersionMap(element.getAttributeValue("centreon-map"));
        } else if (element.getName().equalsIgnoreCase("geo")) {
            identity.setMapToken(element.getAttributeValue("token_id"));
            identity.setApiToken(element.getAttributeValue("type"));
        } else if (element.getName().equalsIgnoreCase("error")) {
            CSIdentityFactory.handleErrorElement(element);
        }
        for (Object child : element.getChildren()) {
            CSIdentityFactory.parseElement((Element)child, identity);
        }
    }
}

