/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.map.client.importmap3.transformer;

import com.centreon.studio.client.events.BrokerEventManager;
import com.centreon.studio.client.events.StudioEvent;
import com.centreon.studio.client.events.exception.ExceptionEvent;
import com.centreon.studio.client.events.log.LogEvent;
import com.centreon.studio.client.model.node.INode;
import com.centreon.studio.client.model.node.INodeRelationListener;
import com.centreon.studio.client.model.relation.INodeRelation;
import com.centreon.studio.map.client.elements.model.ElementPropertyDescriptors;
import com.centreon.studio.map.client.importmap3.transformer.Transformer;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.swt.SWTException;

public class ElementCountListener
implements INodeRelationListener {
    private int currentElementCount;
    private final int totalElementCount;
    private final Transformer transformer;
    private final BrokerEventManager eventManager;
    private final Set<INode> registeredNodes = new HashSet<INode>(1000);

    public ElementCountListener(INode root, Transformer transformer, int total, BrokerEventManager eventManager) {
        this.transformer = transformer;
        this.totalElementCount = total;
        this.registeredNodes.add(root);
        this.eventManager = eventManager;
    }

    public synchronized void relationsAdded(INode node, Collection<INodeRelation> relations) {
        boolean countIsReached;
        this.eventManager.sync((StudioEvent)LogEvent.trace(ElementCountListener.class, (String)("Relation added for node:" + node + "\nAnd relations: " + relations), (Object[])new Object[0]));
        for (INodeRelation relation : relations) {
            INode target = relation.getTarget();
            if (((Boolean)target.getProperty(ElementPropertyDescriptors.SYNCHRONIZED)).booleanValue()) {
                this.eventManager.sync((StudioEvent)LogEvent.trace(ElementCountListener.class, (String)"Target got SYNCHRONIZED property to true, skip it.", (Object[])new Object[0]));
                continue;
            }
            this.eventManager.sync((StudioEvent)LogEvent.trace(ElementCountListener.class, (String)"Target doesn't have SYNCHRONIZED property.", (Object[])new Object[0]));
            ++this.currentElementCount;
            this.eventManager.sync((StudioEvent)LogEvent.trace(ElementCountListener.class, (String)("currentElementCount: " + this.currentElementCount), (Object[])new Object[0]));
            try {
                this.eventManager.sync((StudioEvent)LogEvent.trace(ElementCountListener.class, (String)("Received " + this.currentElementCount + " / " + this.totalElementCount), (Object[])new Object[0]));
                this.transformer.progressMonitor.subTask("Received " + this.currentElementCount + " / " + this.totalElementCount);
            }
            catch (SWTException e) {
                this.eventManager.sync((StudioEvent)LogEvent.trace(ElementCountListener.class, (String)("Error occured while setting progressMonitor subTask : " + (Object)((Object)e)), (Object[])new Object[0]));
                this.eventManager.async((StudioEvent)new ExceptionEvent((Throwable)e));
            }
            this.eventManager.sync((StudioEvent)LogEvent.trace(ElementCountListener.class, (String)("Adding target to registeredNodes: " + this.registeredNodes), (Object[])new Object[0]));
            this.registeredNodes.add(target);
            target.registerRelationsListener((INodeRelationListener)this);
        }
        boolean bl = countIsReached = this.currentElementCount >= this.totalElementCount;
        if (countIsReached) {
            this.eventManager.sync((StudioEvent)LogEvent.trace(ElementCountListener.class, (String)"Count is reached! Terminating import.", (Object[])new Object[0]));
            this.transformer.setFinished(true);
            this.registeredNodes.parallelStream().forEach(registeredNode -> registeredNode.unregisterRelationsListener((INodeRelationListener)this));
        } else {
            this.eventManager.sync((StudioEvent)LogEvent.trace(ElementCountListener.class, (String)("Count is not reached: " + this.currentElementCount + " / " + this.totalElementCount), (Object[])new Object[0]));
        }
    }

    public void relationsRemoved(INode node, Collection<INodeRelation> relations) {
    }
}

