/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.media;

import com.centreon.studio.client.commons.Configuration;
import com.centreon.studio.client.events.BrokerEventManager;
import com.centreon.studio.client.events.StudioEvent;
import com.centreon.studio.client.events.StudioEventHandler;
import com.centreon.studio.client.events.auth.AuthenticationEventHandler;
import com.centreon.studio.client.events.log.LogEvent;
import com.centreon.studio.client.media.MediaSyncEventHandler;
import com.centreon.studio.client.media.events.MediaEvent;
import com.centreon.studio.client.media.events.MediaEventHandler;
import com.centreon.studio.client.media.model.DataWebService;
import com.centreon.studio.client.media.model.MediaRepository;
import com.centreon.studio.client.media.model.MediaTypes;
import com.centreon.studio.client.media.model.MediaWebService;
import com.centreon.studio.client.model.node.INode;
import com.centreon.studio.client.model.node.INodeUtils;
import com.centreon.studio.client.model.object.TypeDescriptor;
import com.centreon.studio.client.model.properties.PropertyValue;
import com.centreon.studio.client.model.repository.IRepository;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.core.runtime.Assert;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public final class MediaAddon
extends MediaEventHandler {
    public static MediaAddon INSTANCE;
    public static final File MEDIA_HOME;
    private final IRepository repository;
    private final DataWebService dataService;
    private final BrokerEventManager eventManager;
    private final MediaSyncEventHandler syncEventHandler;
    private final AuthenticationEventHandler authenticatinEventHandler;

    static {
        MEDIA_HOME = new File(Configuration.APPLI_HOME, "media");
        Assert.isTrue((MEDIA_HOME.exists() || MEDIA_HOME.mkdirs() ? 1 : 0) != 0, (String)"ERROR : !MediaAddon.MEDIA_HOME.exists() && !MediaAddon.MEDIA_HOME.mkdirs()");
    }

    private static long computeTotalSize(File folder) {
        if (folder.listFiles() == null) {
            return 0L;
        }
        long totalSize = 0L;
        File[] fileArray = folder.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (!file.isDirectory() && file.exists()) {
                totalSize += file.length();
            }
            ++n2;
        }
        return totalSize;
    }

    @Inject
    public MediaAddon(BrokerEventManager eventManager, final MediaWebService service, DataWebService dataService, final MediaRepository repository) {
        INSTANCE = this;
        this.repository = repository;
        this.dataService = dataService;
        this.eventManager = eventManager;
        this.authenticatinEventHandler = new AuthenticationEventHandler(){

            protected void loggedIn() {
                this.loadMediaRepository();
            }

            protected void loggedOut() {
                MediaAddon.this.clean();
                this.clearMediaRepository();
            }

            private void clearMediaRepository() {
                repository.setSelection((Object)this, null);
                repository.removeRelations(repository.getRelations(new TypeDescriptor[0]));
            }

            private void loadMediaRepository() {
                List relations = service.getElementsByTypes(Arrays.asList(MediaTypes.MEDIA_GROUP));
                repository.addRelations(relations);
            }
        };
        this.syncEventHandler = new MediaSyncEventHandler(repository, service);
    }

    public BrokerEventManager getEventManager() {
        return this.eventManager;
    }

    public void handleEvent(MediaEvent event) {
        if ("request".equals(event.getAction())) {
            String md5 = event.getMd5();
            File file = this.dataService.download(md5);
            this.eventManager.async((StudioEvent)MediaEvent.createAnswerMediaEvent(md5, file));
        }
    }

    @PostConstruct
    public void postConstruct() {
        this.eventManager.subscribe("studio/media", true, (StudioEventHandler)this);
        this.eventManager.subscribe("studio/sync", true, (StudioEventHandler)this.syncEventHandler);
        this.eventManager.subscribe("studio/authentication", true, (StudioEventHandler)this.authenticatinEventHandler);
        this.eventManager.async((StudioEvent)LogEvent.trace(((Object)((Object)this)).getClass(), (String)"Media addon loaded", (Object[])new Object[0]));
    }

    @PreDestroy
    public void preDestroy() {
        this.eventManager.unsubscribe((StudioEventHandler)this);
        this.eventManager.unsubscribe((StudioEventHandler)this.syncEventHandler);
        this.eventManager.unsubscribe((StudioEventHandler)this.authenticatinEventHandler);
        this.eventManager.async((StudioEvent)LogEvent.trace(((Object)((Object)this)).getClass(), (String)"Media addon destroyed", (Object[])new Object[0]));
    }

    private void clean() {
        File file;
        if (Configuration.CLEAN_MODE == "none") {
            return;
        }
        File folder = MEDIA_HOME;
        long totalSize = MediaAddon.computeTotalSize(folder);
        File[] fileArray = folder.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            file = fileArray[n2];
            String name = file.getName();
            try {
                INode found = INodeUtils.findNode((INode)this.repository, null, (Long)Long.parseLong(name), (PropertyValue[])new PropertyValue[0]);
                if (Configuration.CLEAN_MODE == "all" || found == null) {
                    long fileSize = file.length();
                    if (file.delete()) {
                        totalSize -= fileSize;
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {}
            ++n2;
        }
        if (Configuration.CLEAN_MODE == "size") {
            while (totalSize > (long)Configuration.MEDIA_CACHE_SIZE && folder.listFiles().length > 0) {
                file = folder.listFiles()[0];
                long fileSize = file.length();
                if (!file.delete()) continue;
                totalSize -= fileSize;
            }
        }
    }
}

