/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.media.events;

import com.centreon.studio.client.events.StudioEvent;
import java.io.File;

public final class MediaEvent
extends StudioEvent {
    public static final String TOPIC = "studio/media";
    protected static final String PROPERTY_MEDIA_ID = "mediaId";
    protected static final String PROPERTY_FILE = "mediaFile";
    public static final String ACTION_REQUEST = "request";
    public static final String ACTION_ANSWER = "answer";

    public static final MediaEvent createAnswerMediaEvent(String md5, File file) {
        return new MediaEvent(TOPIC + md5, ACTION_ANSWER, md5, file);
    }

    public static final MediaEvent createRequestMediaEvent(String md5) {
        return new MediaEvent(TOPIC, ACTION_REQUEST, md5, null);
    }

    protected MediaEvent(String topic, String action, String md5, File file) {
        super(topic);
        this.data.put(PROPERTY_FILE, file);
        this.data.put(PROPERTY_MEDIA_ID, md5);
        this.data.put("action", action);
    }

    public String getAction() {
        return (String)this.data.get("action");
    }

    public File getFile() {
        return (File)this.data.get(PROPERTY_FILE);
    }

    public String getMd5() {
        return (String)this.data.get(PROPERTY_MEDIA_ID);
    }
}

