/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.media.model;

import com.centreon.studio.client.commons.ANodeWebService;
import com.centreon.studio.client.events.BrokerEventManager;
import com.centreon.studio.client.media.model.DataWebService;
import com.centreon.studio.client.media.model.MediaPropertyDescriptors;
import com.centreon.studio.client.media.model.MediaRepository;
import com.centreon.studio.client.media.model.MediaTypes;
import com.centreon.studio.client.media.model.MediaUtils;
import com.centreon.studio.client.model.node.INode;
import com.centreon.studio.client.model.object.TypeDescriptor;
import com.centreon.studio.client.model.relation.INodeRelation;
import com.centreon.studio.client.model.repository.IRepository;
import com.centreon.studio.map.elementservice.ElementPortType;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public final class MediaWebService
extends ANodeWebService {
    private final DataWebService data;

    @Inject
    public MediaWebService(MediaRepository repository, BrokerEventManager eventManager, DataWebService data) {
        super((IRepository)repository, eventManager);
        this.data = data;
    }

    public Map<INode, Collection<INodeRelation>> create(Map<INode, Collection<INodeRelation>> nodeToRelations) {
        HashMap<INode, ArrayList<INodeRelation>> toDelete = new HashMap<INode, ArrayList<INodeRelation>>();
        Map result = super.create(nodeToRelations);
        for (Collection relations : result.values()) {
            for (INodeRelation relation : relations) {
                if (this.upload(relation)) continue;
                ArrayList<INodeRelation> toDel = (ArrayList<INodeRelation>)toDelete.get(relation.getSource());
                if (toDel == null) {
                    toDel = new ArrayList<INodeRelation>();
                    toDelete.put(relation.getSource(), toDel);
                }
                toDel.add(relation);
            }
        }
        if (!toDelete.isEmpty()) {
            this.remove(toDelete);
        }
        return result;
    }

    protected TypeDescriptor getRelationType() {
        return MediaTypes.MEDIA_RELATION;
    }

    protected boolean isWebServiceInitialized() {
        try {
            ((ElementPortType)this.service).getElementsByType(null, Arrays.asList(-1), 0);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean upload(INodeRelation relation) {
        if (relation.getTarget().getType() == MediaTypes.MEDIA_GROUP) {
            return true;
        }
        String md5 = (String)relation.getTarget().getProperty(MediaPropertyDescriptors.MD5);
        File file = MediaUtils.getMediaLocalFile(relation.getTarget());
        if (!file.exists()) {
            return false;
        }
        return this.data.upload(md5, file);
    }
}

