/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.media.model.relation;

import com.centreon.studio.client.media.model.MediaTypes;
import com.centreon.studio.client.media.model.relation.MediaRelation;
import com.centreon.studio.client.model.node.INode;
import com.centreon.studio.client.model.object.TypeDescriptor;
import com.centreon.studio.client.model.properties.PropertyValue;
import com.centreon.studio.client.model.relation.INodeRelation;
import com.centreon.studio.client.model.relation.INodeRelationFactory;
import java.util.ArrayList;
import java.util.Collection;

public enum MediaRelationFactory implements INodeRelationFactory
{
    INSTANCE;

    private static final Collection<TypeDescriptor> SUPPORTED_TYPES;

    static {
        SUPPORTED_TYPES = new ArrayList<TypeDescriptor>(3);
        SUPPORTED_TYPES.add(MediaTypes.MEDIA_RELATION);
        SUPPORTED_TYPES.add(MediaTypes.MEDIA_RELATION_IMAGE);
        SUPPORTED_TYPES.add(MediaTypes.MEDIA_RELATION_SOUND);
    }

    public INodeRelation create(TypeDescriptor type, Long id, INode source, INode target, Collection<PropertyValue> properties) {
        if (target.getType() == MediaTypes.MEDIA_SOUND) {
            return new MediaRelation(MediaTypes.MEDIA_RELATION_SOUND, id, source, target, properties);
        }
        if (target.getType() == MediaTypes.MEDIA_IMAGE) {
            return new MediaRelation(MediaTypes.MEDIA_RELATION_IMAGE, id, source, target, properties);
        }
        return new MediaRelation(MediaTypes.MEDIA_RELATION, id, source, target, properties);
    }

    public Collection<TypeDescriptor> getSupportedTypes() {
        return SUPPORTED_TYPES;
    }
}

