/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.system.commands;

import com.centreon.studio.client.acl.ACLUser;
import com.centreon.studio.client.commons.jface.dialogs.MessageDialogUtils;
import com.centreon.studio.client.commons.jface.validation.ControlValidators;
import com.centreon.studio.client.commons.jface.validation.field.impl.FileField;
import com.centreon.studio.client.commons.jface.validation.field.impl.TextField;
import com.centreon.studio.client.commons.jface.validation.form.IForm;
import com.centreon.studio.client.commons.swt.SWTUtils;
import com.centreon.studio.client.events.BrokerEventManager;
import com.centreon.studio.client.events.StudioEvent;
import com.centreon.studio.client.events.exception.ExceptionEvent;
import com.centreon.studio.client.model.messages.ModelMessages;
import com.centreon.studio.client.model.node.INode;
import com.centreon.studio.client.model.object.AObject;
import com.centreon.studio.client.model.object.TypeDescriptor;
import com.centreon.studio.client.model.properties.PropertyDescriptor;
import com.centreon.studio.client.model.properties.PropertyValue;
import com.centreon.studio.client.model.relation.INodeRelation;
import com.centreon.studio.client.model.relation.NodeRelationFactories;
import com.centreon.studio.client.model.repository.IRepository;
import com.centreon.studio.client.model.repository.IRepositoryListener;
import com.centreon.studio.client.model.ui.actions.common.StudioAction;
import com.centreon.studio.client.model.ui.actions.edit.RemoveNodesAction;
import com.centreon.studio.client.model.ui.controls.impl.NodeCombo;
import com.centreon.studio.client.model.ui.controls.impl.StudioActionButton;
import com.centreon.studio.client.preference.ui.pages.AObjectScopedPreferencePage;
import com.centreon.studio.client.system.commands.messages.SystemCommandMessages;
import com.centreon.studio.client.system.commands.model.ClassPropertyDescriptorAssociator;
import com.centreon.studio.client.system.commands.model.SystemCommand;
import com.centreon.studio.client.system.commands.model.SystemCommandPropertyDescriptors;
import com.centreon.studio.client.system.commands.model.SystemCommandRepository;
import com.centreon.studio.client.system.commands.model.SystemCommandTypes;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import javax.inject.Inject;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class SystemCommandsPreferencePage
extends AObjectScopedPreferencePage
implements IRepositoryListener {
    private final SystemCommandRepository systemCommandRepository;
    private final BrokerEventManager eventManager;
    private TextField nameField;
    private FileField pathField;
    private TextField argsField;

    /*
     * WARNING - void declaration
     */
    private static void createMacroTable(Composite parent) {
        void var5_12;
        TableItem item;
        Table table = new Table(parent, 67586);
        GridData data = new GridData(4, 4, true, true);
        data.heightHint = 200;
        table.setLayoutData((Object)data);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        TableColumn nameColumn = new TableColumn(table, 0);
        nameColumn.setText(SystemCommandMessages.macroColumnName);
        TableColumn descriptionColumn = new TableColumn(table, 0);
        descriptionColumn.setText(SystemCommandMessages.macroColumnDescription);
        for (Map.Entry<String, PropertyDescriptor<?>> entry : SystemCommandRepository.MACRO_TO_PROPERTY_DESCRIPTOR.entrySet()) {
            item = new TableItem(table, 0);
            item.setText(0, entry.getKey());
            item.setText(1, entry.getValue().label);
        }
        for (Map.Entry<String, Object> entry : SystemCommandRepository.MACRO_TO_DUO.entrySet()) {
            item = new TableItem(table, 0);
            item.setText(0, entry.getKey());
            item.setText(1, ((ClassPropertyDescriptorAssociator)entry.getValue()).getPropertyDescriptor().label);
        }
        for (Map.Entry<String, Object> entry : SystemCommandRepository.MACRO_TO_SYSTEM.entrySet()) {
            item = new TableItem(table, 0);
            item.setText(0, entry.getKey());
            item.setText(1, (String)entry.getValue());
        }
        boolean bl = false;
        while (var5_12 < 2) {
            table.getColumn((int)var5_12).pack();
            ++var5_12;
        }
        SWTUtils.createLabel((Composite)parent, (String)SystemCommandMessages.macroExplicationText, (int)1, (int)1, (int)300, (int)300);
    }

    @Inject
    public SystemCommandsPreferencePage(ACLUser user, SystemCommandRepository repository, BrokerEventManager eventManager) {
        super("System", (INode)user);
        this.systemCommandRepository = repository;
        this.eventManager = eventManager;
    }

    protected void createHeadContents(Composite parent) {
        Composite composite = SWTUtils.createComposite((Composite)parent, (int)3, (boolean)false);
        SWTUtils.createLabel((Composite)composite, (String)SystemCommandMessages.labelCommands);
        new NodeCombo(composite, (INode)this.systemCommandRepository, new TypeDescriptor[]{SystemCommandTypes.SYSTEM_COMMAND});
        new StudioActionButton(composite, (StudioAction)new RemoveNodesAction((IRepository)this.systemCommandRepository));
        Group group = SWTUtils.createGroup((Composite)composite, (String)SystemCommandMessages.createSystemCommand, (int)10, (int)2, (boolean)false, (GridData)new GridData(4, 1, true, false, 3, 1));
        this.nameField = new TextField(SWTUtils.createText((Composite)group), ModelMessages.propertyLabel, "", (IForm)this.form, ControlValidators.TEXT_NON_EMPTY_VALIDATOR);
        this.pathField = new FileField((Composite)group, SystemCommandMessages.labelPath, "", (IForm)this.form, ControlValidators.TEXT_NON_EMPTY_VALIDATOR, 4096);
        this.argsField = new TextField(SWTUtils.createText((Composite)group), SystemCommandMessages.labelArgs, "", (IForm)this.form, null);
        this.systemCommandRepository.registerSelectionListener(this);
        group.addDisposeListener(disposeEvent -> this.systemCommandRepository.unregisterSelectionListener(this));
        this.fillForm(this.systemCommandRepository.getSelection());
        SystemCommandsPreferencePage.createMacroTable(composite);
    }

    private void fillForm(INodeRelation selection) {
        if (selection == null) {
            this.performDefaults();
        } else {
            this.nameField.setValue((Object)((String)selection.getTarget().getProperty(AObject.LABEL)));
            this.pathField.setValue((Object)((String)selection.getTarget().getProperty(SystemCommandPropertyDescriptors.PATH)));
            this.argsField.setValue((Object)((String)selection.getTarget().getProperty(SystemCommandPropertyDescriptors.ARGS)));
        }
        ((Text)this.nameField.getControl()).setFocus();
        ((Text)this.nameField.getControl()).setSelection(this.nameField.getValue().length(), this.nameField.getValue().length());
    }

    protected void performApply() {
        if (this.form.isValid() && this.form.hasChanged()) {
            ArrayList<PropertyValue> properties = new ArrayList<PropertyValue>(3);
            properties.add(new PropertyValue(AObject.LABEL, (Object)this.nameField.getValue()));
            properties.add(new PropertyValue(SystemCommandPropertyDescriptors.PATH, (Object)this.pathField.getValue()));
            properties.add(new PropertyValue(SystemCommandPropertyDescriptors.ARGS, (Object)this.argsField.getValue()));
            SystemCommand newObject = new SystemCommand(null, properties, (IRepository)this.systemCommandRepository);
            INodeRelation toReplace = null;
            for (INodeRelation child : this.systemCommandRepository.getRelations(new TypeDescriptor[]{SystemCommandTypes.SYSTEM_COMMAND})) {
                if (!child.getTarget().equals((Object)newObject)) continue;
                toReplace = child;
                break;
            }
            if (toReplace != null) {
                if (MessageDialogUtils.openConfirm((String)SystemCommandMessages.confirmReplaceSystemCommand)) {
                    this.systemCommandRepository.removeRelation(toReplace);
                } else {
                    return;
                }
            }
            INodeRelation newRelation = this.systemCommandRepository.addRelation(NodeRelationFactories.INSTANCE.create((INode)this.systemCommandRepository, (INode)newObject));
            this.systemCommandRepository.setSelection(this.getControl(), Arrays.asList(newRelation));
            try {
                this.systemCommandRepository.save();
            }
            catch (IOException e) {
                this.eventManager.async((StudioEvent)new ExceptionEvent((Throwable)new Exception(SystemCommandMessages.errorSaveCommand, e)));
            }
        }
    }

    protected void performDefaults() {
        this.nameField.resetDefault();
        this.pathField.resetDefault();
        this.argsField.resetDefault();
    }

    public final void selectionChanged(Object source, IRepository repository) {
        this.fillForm(repository.getSelection());
    }
}

