/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.events;

import com.centreon.studio.client.events.StudioEvent;
import com.centreon.studio.client.events.StudioEventHandler;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.eclipse.e4.core.services.events.IEventBroker;

@Creatable
@Singleton
public class BrokerEventManager {
    private final IEventBroker eventBroker;

    @Inject
    public BrokerEventManager(IEventBroker eventBroker) {
        this.eventBroker = eventBroker;
    }

    public boolean async(StudioEvent event) {
        if (event == null || this.eventBroker == null) {
            return false;
        }
        return this.eventBroker.post(event.getTopic(), event.data);
    }

    public boolean subscribe(String topic, boolean headless, StudioEventHandler<?> handler) {
        if (handler == null || this.eventBroker == null) {
            return false;
        }
        return this.eventBroker.subscribe(topic, null, handler, headless);
    }

    public boolean sync(StudioEvent event) {
        if (event == null || this.eventBroker == null) {
            return false;
        }
        return this.eventBroker.send(event.getTopic(), event.data);
    }

    public boolean unsubscribe(StudioEventHandler<?> handler) {
        if (handler == null || this.eventBroker == null) {
            return false;
        }
        return this.eventBroker.unsubscribe(handler);
    }
}

