/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.events;

import com.centreon.studio.client.utils.StringUtils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;

public abstract class StudioEvent {
    public static final String STUDIO_ROOT_TOPIC = "studio/";
    public static final String PROPERTY_ACTION = "action";
    private final String topic;
    protected final Map<String, Object> data;

    protected StudioEvent(String topic) {
        this(topic, new HashMap<String, Object>(8));
    }

    private StudioEvent(String topic, Map<String, Object> data) {
        Assert.isTrue((!StringUtils.isNullEmptyOrBlank((String)topic) ? 1 : 0) != 0, (String)"topic must not be null");
        Assert.isNotNull(data);
        this.topic = topic;
        this.data = data;
        this.data.put("timestamp", System.currentTimeMillis());
    }

    public String getTopic() {
        return this.topic;
    }

    public final String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName());
        builder.append(" [topic=");
        builder.append(this.topic);
        builder.append(", data=");
        builder.append(StringUtils.NEW_LINE);
        for (Map.Entry<String, Object> e : this.data.entrySet()) {
            builder.append("   ");
            builder.append(e.getKey());
            builder.append("=");
            if (e.getValue() instanceof Object[]) {
                builder.append(Arrays.toString((Object[])e.getValue()));
            } else {
                builder.append(e.getValue());
            }
            builder.append(StringUtils.NEW_LINE);
        }
        builder.append("]");
        return builder.toString();
    }
}

