/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.events.exception;

import com.centreon.studio.client.events.StudioEvent;
import com.centreon.studio.client.utils.StringUtils;
import org.eclipse.core.runtime.Assert;

public final class ExceptionEvent
extends StudioEvent {
    public static final String TOPIC = "studio/exceptions";
    public static final String ADD_FILTER = "addFilter";
    public static final String ADD_PATTERN = "addPattern";
    public static final String REMOVE_FILTER = "removeFilter";
    public static final String REMOVE_PATTERN = "removePattern";
    public static final String REGISTER_EXCEPTION = "registerException";
    static final String PROPERTY_EXCEPTION = "exception";
    static final String PROPERTY_CONTAINS = "contains";
    static final String PROPERTY_FILTER = "filter";
    static final String PROPERTY_PRINT = "print";

    public static ExceptionEvent addFilter(String filter) {
        return new ExceptionEvent(ADD_FILTER, filter, null, null);
    }

    public static ExceptionEvent addPattern(String contains, String print) {
        return new ExceptionEvent(ADD_PATTERN, null, contains, print);
    }

    public static ExceptionEvent registerException(String pattern, String url) {
        return new ExceptionEvent(REGISTER_EXCEPTION, null, pattern, url);
    }

    public static ExceptionEvent removeFilter(String filter) {
        return new ExceptionEvent(REMOVE_FILTER, filter, null, null);
    }

    public static ExceptionEvent removePattern(String contains) {
        return new ExceptionEvent(REMOVE_PATTERN, null, contains, contains);
    }

    public ExceptionEvent(Throwable e) {
        super(TOPIC);
        Assert.isNotNull((Object)e);
        this.data.put(PROPERTY_EXCEPTION, e);
    }

    ExceptionEvent(String action, String filter, String contains, String print) {
        super(TOPIC);
        Assert.isTrue((!StringUtils.isNullEmptyOrBlank((String)action) && (!StringUtils.isNullEmptyOrBlank((String)filter) || !StringUtils.isOneNullEmptyOrBlank((String[])new String[]{contains, print})) ? 1 : 0) != 0);
        this.data.put(PROPERTY_FILTER, filter);
        this.data.put("action", action);
        this.data.put(PROPERTY_CONTAINS, contains);
        this.data.put(PROPERTY_PRINT, print);
    }

    public String getAction() {
        return (String)this.data.get("action");
    }

    public String getContains() {
        return (String)this.data.get(PROPERTY_CONTAINS);
    }

    public Throwable getException() {
        return (Throwable)this.data.get(PROPERTY_EXCEPTION);
    }

    public String getFilter() {
        return (String)this.data.get(PROPERTY_FILTER);
    }

    public String getPrint() {
        return (String)this.data.get(PROPERTY_PRINT);
    }
}

