/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.events.log;

import com.centreon.studio.client.events.StudioEvent;
import com.centreon.studio.client.utils.StringUtils;
import org.eclipse.core.runtime.Assert;

public final class LogEvent
extends StudioEvent {
    public static final LogLevel LOG_LEVEL = LogLevel.fromString(System.getProperty("log.level"));
    public static final String TOPIC = "studio/logs";
    static final String PROPERTY_LEVEL = "level";
    static final String PROPERTY_THROWABLE = "throwable";
    static final String PROPERTY_LOGGER_CLASS = "class";
    static final String PROPERTY_MESSAGE = "message";
    static final String PROPERTY_ARGS = "args";

    public static LogEvent error(Class<?> loggerClass, String message, Object ... args) {
        return new LogEvent(loggerClass, LogLevel.ERROR, message, args);
    }

    public static LogEvent exception(Class<?> loggerClass, Throwable throwable) {
        return new LogEvent(loggerClass, throwable);
    }

    public static LogEvent trace(Class<?> loggerClass, String message, Object ... args) {
        if (!LOG_LEVEL.shouldLog(LogLevel.TRACE)) {
            return null;
        }
        return new LogEvent(loggerClass, LogLevel.TRACE, message, args);
    }

    LogEvent(Class<?> loggerClass, LogLevel level, String message, Object ... args) {
        super(TOPIC);
        Assert.isTrue((level != null ? 1 : 0) != 0, (String)"Logging level must not me null");
        Assert.isTrue((loggerClass != null && !StringUtils.isOneNullEmptyOrBlank((String[])new String[]{message}) ? 1 : 0) != 0, (String)"Logger name & message must not be null or empty");
        this.data.put(PROPERTY_LOGGER_CLASS, loggerClass);
        this.data.put(PROPERTY_MESSAGE, message);
        this.data.put(PROPERTY_LEVEL, level);
        if (args != null) {
            this.data.put(PROPERTY_ARGS, args);
        }
    }

    LogEvent(Class<?> loggerClass, Throwable throwable) {
        super(TOPIC);
        Assert.isTrue((throwable != null && loggerClass != null ? 1 : 0) != 0);
        this.data.put(PROPERTY_LOGGER_CLASS, loggerClass);
        this.data.put(PROPERTY_LEVEL, LogLevel.ERROR);
        this.data.put(PROPERTY_THROWABLE, throwable);
    }

    public Object[] getArgs() {
        return (Object[])this.data.get(PROPERTY_ARGS);
    }

    public Class<?> getLoggerClass() {
        return (Class)this.data.get(PROPERTY_LOGGER_CLASS);
    }

    public LogLevel getLogLevel() {
        return (LogLevel)((Object)this.data.get(PROPERTY_LEVEL));
    }

    public String getMessage() {
        return (String)this.data.get(PROPERTY_MESSAGE);
    }

    public Throwable getThrowable() {
        return (Throwable)this.data.get(PROPERTY_THROWABLE);
    }

    public static enum LogLevel {
        ALL(0),
        TRACE(20),
        INFO(40),
        DEBUG(60),
        WARNING(80),
        ERROR(100);

        private int value;

        public static LogLevel fromString(String logLevel) {
            if (logLevel == null) {
                return ERROR;
            }
            switch (logLevel.toLowerCase()) {
                case "all": {
                    return ALL;
                }
                case "trace": {
                    return TRACE;
                }
                case "info": {
                    return INFO;
                }
                case "debug": {
                    return DEBUG;
                }
            }
            return ERROR;
        }

        private LogLevel(int value) {
            this.value = value;
        }

        public boolean shouldLog(LogLevel other) {
            return other.value >= this.value;
        }
    }
}

