/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.events.popup;

import com.centreon.studio.client.events.StudioEvent;
import com.centreon.studio.client.events.popup.IPopUpRunnable;
import com.centreon.studio.client.utils.StringUtils;
import org.eclipse.swt.graphics.Color;

public final class PopUpEvent
extends StudioEvent {
    public static final String IMAGE_OK = "platform:/plugin/com.centreon.studio.client.events/img/ok.png";
    public static final String IMAGE_INFO = "platform:/plugin/com.centreon.studio.client.events/img/info.png";
    public static final String IMAGE_ERROR = "platform:/plugin/com.centreon.studio.client.events/img/error.png";
    public static final String IMAGE_CONNECTED = "platform:/plugin/com.centreon.studio.client.events/img/connected.png";
    public static final String IMAGE_DISCONNECTED = "platform:/plugin/com.centreon.studio.client.events/img/disconnected.png";
    public static final String TOPIC = "studio/popup";
    static final String PROPERTY_IMAGE_PATH = "imagePath";
    static final String PROPERTY_DURATION = "duration";
    static final String PROPERTY_CATEGORY = "category";
    static final String PROPERTY_MESSAGE = "message";
    static final String PROPERTY_CONTENT = "content";
    static final String PROPERTY_HEIGHT = "heght";
    static final String PROPERTY_COLOR = "color";
    static final String PROPERTY_WIDTH = "width";
    static final String PROPERTY_TITLE = "title";
    static final String PROPERTY_HPOS = "hpos";
    static final String PROPERTY_VPOS = "vpos";

    public PopUpEvent() {
        super(TOPIC);
    }

    public IPopUpRunnable getAction() {
        return (IPopUpRunnable)this.data.get("action");
    }

    public String getCategory() {
        return (String)this.data.get(PROPERTY_CATEGORY);
    }

    public Color getColor() {
        return (Color)this.data.get(PROPERTY_COLOR);
    }

    public Long getDuration() {
        return StringUtils.parseLong((String)((String)this.data.get(PROPERTY_DURATION)), (long)Long.MIN_VALUE);
    }

    public int getHeight() {
        return StringUtils.parseInt((String)((String)this.data.get(PROPERTY_HEIGHT)));
    }

    public int getHPos() {
        return StringUtils.parseInt((String)((String)this.data.get(PROPERTY_HPOS)));
    }

    public String getImagePath() {
        return (String)this.data.get(PROPERTY_IMAGE_PATH);
    }

    public String getMessage() {
        return (String)this.data.get(PROPERTY_MESSAGE);
    }

    public String getTitle() {
        return (String)this.data.get(PROPERTY_TITLE);
    }

    public int getVPos() {
        return StringUtils.parseInt((String)((String)this.data.get(PROPERTY_VPOS)));
    }

    public int getWidth() {
        return StringUtils.parseInt((String)((String)this.data.get(PROPERTY_WIDTH)));
    }

    public PopUpEvent setAction(IPopUpRunnable runnable) {
        this.data.put("action", runnable);
        return this;
    }

    public PopUpEvent setBounds(int width, int height) {
        this.data.put(PROPERTY_WIDTH, String.valueOf(width));
        this.data.put(PROPERTY_HEIGHT, String.valueOf(height));
        return this;
    }

    public PopUpEvent setCategory(String category) {
        this.data.put(PROPERTY_CATEGORY, category);
        return this;
    }

    public PopUpEvent setColor(Color color) {
        this.data.put(PROPERTY_COLOR, color);
        return this;
    }

    public PopUpEvent setDuration(long duration) {
        this.data.put(PROPERTY_DURATION, String.valueOf(duration));
        return this;
    }

    public PopUpEvent setImagePath(String path) {
        this.data.put(PROPERTY_IMAGE_PATH, path);
        return this;
    }

    public PopUpEvent setPos(int x, int y) {
        this.data.put(PROPERTY_HPOS, String.valueOf(x));
        this.data.put(PROPERTY_VPOS, String.valueOf(y));
        return this;
    }

    public PopUpEvent setTexts(String title, String message) {
        this.data.put(PROPERTY_TITLE, title);
        this.data.put(PROPERTY_MESSAGE, message);
        return this;
    }
}

