/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.events.sync;

import com.centreon.studio.client.events.StudioEvent;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;

public class SyncEvent
extends StudioEvent {
    public static final String TOPIC = "studio/sync";
    private static final String PROPERTY_TYPE = "type";
    private static final String PROPERTY_DATA = "data";

    public SyncEvent(SyncAction action, Integer type, Collection<SyncData> data) {
        super(TOPIC);
        Assert.isNotNull((Object)type);
        Assert.isNotNull((Object)((Object)action));
        Assert.isTrue((data != null && !data.isEmpty() ? 1 : 0) != 0);
        this.data.put(PROPERTY_DATA, data);
        this.data.put(PROPERTY_TYPE, type);
        this.data.put("action", action);
    }

    public SyncEvent(SyncAction action, Integer type, Long id) {
        this(action, type, Arrays.asList(new SyncData(id)));
    }

    protected SyncEvent(Map<String, Object> properties) {
        super(TOPIC);
        this.data.putAll(properties);
        Assert.isTrue((this.getData() != null && !this.getData().isEmpty() ? 1 : 0) != 0);
        Assert.isNotNull((Object)this.getType());
        Assert.isNotNull((Object)((Object)this.getAction()));
    }

    public SyncAction getAction() {
        return (SyncAction)((Object)this.data.get("action"));
    }

    public Collection<SyncData> getData() {
        return (Collection)this.data.get(PROPERTY_DATA);
    }

    public Integer getType() {
        return (Integer)this.data.get(PROPERTY_TYPE);
    }

    public static enum SyncAction {
        CREATE("create"),
        UPDATE("update"),
        REMOVE("remove"),
        INFORMATION("information"),
        ERROR("error");

        private final String label;

        public static SyncAction fromString(String actionLabel) {
            SyncAction[] syncActionArray = SyncAction.values();
            int n = syncActionArray.length;
            int n2 = 0;
            while (n2 < n) {
                SyncAction action = syncActionArray[n2];
                if (action.label.equals(actionLabel)) {
                    return action;
                }
                ++n2;
            }
            return null;
        }

        private SyncAction(String label) {
            this.label = label;
        }
    }

    public static class SyncData {
        private final Long id;
        private Map<String, Object> properties;

        public SyncData(Long id) {
            this.id = id;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SyncData other = (SyncData)obj;
            if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
                return false;
            }
            return !(this.properties == null ? other.properties != null : !this.properties.equals(other.properties));
        }

        public Long getId() {
            return this.id;
        }

        public Object getProperty(String key) {
            if (this.properties == null) {
                return null;
            }
            return this.properties.get(key);
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
            result = 31 * result + (this.properties == null ? 0 : this.properties.hashCode());
            return result;
        }

        public void setProperty(String key, Object value) {
            if (this.properties == null) {
                this.properties = new HashMap<String, Object>();
            }
            this.properties.put(key, value);
        }

        public String toString() {
            return "SyncData [id=" + this.id + ", properties=" + this.properties + "]";
        }
    }
}

