/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.popup;

import com.centreon.studio.client.acl.ACLUser;
import com.centreon.studio.client.commons.ContextUtils;
import com.centreon.studio.client.commons.Scheduler;
import com.centreon.studio.client.commons.swt.SWTUtils;
import com.centreon.studio.client.events.BrokerEventManager;
import com.centreon.studio.client.events.StudioEvent;
import com.centreon.studio.client.events.StudioEventHandler;
import com.centreon.studio.client.events.log.LogEvent;
import com.centreon.studio.client.events.popup.PopUpEvent;
import com.centreon.studio.client.events.popup.PopUpEventHandler;
import com.centreon.studio.client.model.node.INode;
import com.centreon.studio.client.model.node.INodeUtils;
import com.centreon.studio.client.model.object.TypeDescriptor;
import com.centreon.studio.client.model.properties.PropertyValue;
import com.centreon.studio.client.popup.NotifierDialog;
import com.centreon.studio.client.popup.PopUpSyncEventHandler;
import com.centreon.studio.client.popup.model.PopupPreferenceDescriptors;
import com.centreon.studio.client.preference.model.PreferenceRepository;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Monitor;

@Creatable
@Singleton
public final class PopUpAddon
extends PopUpEventHandler {
    private static final int DEFAULT_HPOS = 131072;
    private static final int DEFAULT_VPOS = 1024;
    private static final int MARGIN = 5;
    private static final int MIN_HEIGHT = 100;
    private static final int MIN_WIDTH = 350;
    private static final int POPUP_THREAD_CLEANUP = 5000;
    private final Map<String, Long> currentEvents = Collections.synchronizedMap(new HashMap(10));
    private final PreferenceRepository preferenceRepository;
    private final PopUpSyncEventHandler popUpSyncEventHandler;
    private final MApplication application;
    private final IEclipseContext context;
    private final ScheduledFuture<?> future;

    @Inject
    public PopUpAddon(MApplication application, BrokerEventManager eventManager, Scheduler scheduler, IEclipseContext context, PreferenceRepository preferenceRepository) {
        this.context = context;
        this.application = application;
        this.preferenceRepository = preferenceRepository;
        this.future = scheduler.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                Iterator it = PopUpAddon.this.currentEvents.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry entry = it.next();
                    if (System.currentTimeMillis() - (Long)entry.getValue() <= 5000L) continue;
                    it.remove();
                }
            }
        }, 0L, 5000L, TimeUnit.MILLISECONDS);
        this.popUpSyncEventHandler = new PopUpSyncEventHandler(eventManager, context, preferenceRepository);
    }

    public void handleEvent(PopUpEvent event) {
        INode userScope;
        ACLUser user = (ACLUser)ContextUtils.getTopContext((IEclipseContext)this.context).get(ACLUser.class);
        if (user != null && (userScope = INodeUtils.findNode((INode)this.preferenceRepository, (TypeDescriptor)user.getType(), (Long)user.getId(), (PropertyValue[])new PropertyValue[0])) != null && ((Boolean)userScope.getProperty(PopupPreferenceDescriptors.DISABLE_POPUPS)).booleanValue()) {
            return;
        }
        if (this.currentEvents.containsKey(event.getMessage())) {
            return;
        }
        this.currentEvents.put(event.getMessage(), System.currentTimeMillis());
        this.showEvent(event);
    }

    @PostConstruct
    public void postConstruct(BrokerEventManager eventManager) {
        eventManager.subscribe("studio/popup", false, (StudioEventHandler)this);
        eventManager.subscribe("studio/sync", true, (StudioEventHandler)this.popUpSyncEventHandler);
        eventManager.async((StudioEvent)LogEvent.trace(((Object)((Object)this)).getClass(), (String)"Popup addon loaded", (Object[])new Object[0]));
    }

    @PreDestroy
    public void preDestroy(BrokerEventManager eventManager) {
        this.future.cancel(false);
        eventManager.unsubscribe((StudioEventHandler)this);
        eventManager.unsubscribe((StudioEventHandler)this.popUpSyncEventHandler);
        eventManager.async((StudioEvent)LogEvent.trace(((Object)((Object)this)).getClass(), (String)"Popup addon destroyed", (Object[])new Object[0]));
    }

    private Monitor getMonitor() {
        MWindow mainWindow = null;
        for (MWindow window : this.application.getChildren()) {
            if (!window.getTags().contains("main")) continue;
            mainWindow = window;
            break;
        }
        if (mainWindow == null) {
            return SWTUtils.getCursorMonitor();
        }
        Point topCorner = new Point(mainWindow.getX(), mainWindow.getY());
        Monitor[] monitorArray = Display.getDefault().getMonitors();
        int n = monitorArray.length;
        int n2 = 0;
        while (n2 < n) {
            Monitor m = monitorArray[n2];
            if (m.getBounds().contains(topCorner)) {
                return m;
            }
            ++n2;
        }
        return SWTUtils.getCursorMonitor();
    }

    private void showEvent(PopUpEvent event) {
        Rectangle monitorBounds = this.getMonitor().getBounds();
        int width = event.getWidth() > 350 ? event.getWidth() : 350;
        int height = event.getHeight() > 100 ? event.getHeight() : 100;
        int hpos = event.getHPos() == 16384 || event.getHPos() == 131072 ? event.getHPos() : 131072;
        int vpos = event.getVPos() == 128 || event.getVPos() == 1024 ? event.getVPos() : 1024;
        int x = hpos == 16384 ? 5 : monitorBounds.width - width - 5;
        int y = vpos == 128 ? 5 : monitorBounds.height - height - 5;
        Rectangle finalRect = new Rectangle(x + monitorBounds.x, y + monitorBounds.y, width, height);
        NotifierDialog.notify(event, finalRect);
    }
}

