/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.popup;

import com.centreon.studio.client.acl.ACLUser;
import com.centreon.studio.client.commons.ContextUtils;
import com.centreon.studio.client.events.BrokerEventManager;
import com.centreon.studio.client.events.StudioEvent;
import com.centreon.studio.client.events.popup.PopUpEvent;
import com.centreon.studio.client.events.sync.SyncEvent;
import com.centreon.studio.client.events.sync.SyncEventHandler;
import com.centreon.studio.client.model.node.INode;
import com.centreon.studio.client.model.node.INodeUtils;
import com.centreon.studio.client.model.object.TypeDescriptor;
import com.centreon.studio.client.model.properties.PropertyValue;
import com.centreon.studio.client.model.repository.IRepository;
import com.centreon.studio.client.popup.model.PopUpTypes;
import com.centreon.studio.client.popup.model.PopupPreferenceDescriptors;
import com.centreon.studio.client.preference.model.PreferenceRepository;
import java.util.Collections;
import org.eclipse.e4.core.contexts.IEclipseContext;

public class PopUpSyncEventHandler
extends SyncEventHandler {
    private static final String TITLE = "title";
    private static final String MESSAGE = "message";
    private final IEclipseContext context;
    private final BrokerEventManager eventManager;
    private final IRepository preferenceRepository;

    public PopUpSyncEventHandler(BrokerEventManager eventManager, IEclipseContext context, PreferenceRepository preferenceRepository) {
        super(Collections.singletonList(PopUpTypes.POPUP.getId()));
        this.preferenceRepository = preferenceRepository;
        this.eventManager = eventManager;
        this.context = context;
    }

    public void handleEvent(SyncEvent event) {
        ACLUser user = (ACLUser)ContextUtils.getTopContext((IEclipseContext)this.context).get(ACLUser.class);
        INode userScope = INodeUtils.findNode((INode)this.preferenceRepository, (TypeDescriptor)user.getType(), (Long)user.getId(), (PropertyValue[])new PropertyValue[0]);
        if (userScope != null && !((Boolean)userScope.getProperty(PopupPreferenceDescriptors.SHOW_INFO_POPUP)).booleanValue()) {
            return;
        }
        String imagePath = event.getAction() == SyncEvent.SyncAction.ERROR ? "platform:/plugin/com.centreon.studio.client.events/img/error.png" : "platform:/plugin/com.centreon.studio.client.events/img/info.png";
        for (SyncEvent.SyncData data : event.getData()) {
            String title = data.getProperty(TITLE) != null ? data.getProperty(TITLE).toString() : "";
            String message = data.getProperty(MESSAGE) != null ? data.getProperty(MESSAGE).toString() : "";
            this.eventManager.async((StudioEvent)new PopUpEvent().setTexts(title, message).setImagePath(imagePath));
        }
    }
}

