/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.map.client.elements.bam.gef.editparts;

import com.centreon.studio.client.commons.jface.StudioRegistries;
import com.centreon.studio.client.commons.swt.SWTUtils;
import com.centreon.studio.client.model.Pos;
import com.centreon.studio.client.model.StudioColor;
import com.centreon.studio.client.model.StudioTypes;
import com.centreon.studio.client.model.node.INode;
import com.centreon.studio.client.model.object.TypeDescriptor;
import com.centreon.studio.client.model.property.PropertyDescriptors;
import com.centreon.studio.client.model.relation.INodeRelation;
import com.centreon.studio.client.model.relation.NodeRelationFactories;
import com.centreon.studio.map.client.elements.bam.model.BAMElementTypes;
import com.centreon.studio.map.client.elements.gef.editparts.ResourceElementGraphicalEditPart;
import com.centreon.studio.map.client.elements.model.ElementPropertyDescriptors;
import com.centreon.studio.map.client.status.model.StatusPropertyDescriptors;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.draw2d.geometry.Point;

public class BAGraphicalEditPart
extends ResourceElementGraphicalEditPart {
    private static final Collection<TypeDescriptor> SUPPORTED_TYPES = Arrays.asList(BAMElementTypes.ELEMENT_BA, BAMElementTypes.ELEMENT_KPI_BA, BAMElementTypes.ELEMENT_KPI_META, BAMElementTypes.ELEMENT_KPI_SERVICE, BAMElementTypes.ELEMENT_KPI_BOOLEAN);

    public BAGraphicalEditPart(INodeRelation relation) {
        super(relation);
    }

    protected List<INodeRelation> getModelSourceConnections() {
        List links = this.getModel().getTarget().getRelations(new TypeDescriptor[0]);
        if (links == Collections.EMPTY_LIST) {
            return Collections.emptyList();
        }
        ArrayList<INodeRelation> actualLinks = new ArrayList<INodeRelation>(links.size());
        for (INodeRelation link : links) {
            if (!SUPPORTED_TYPES.contains(link.getTarget().getType())) continue;
            actualLinks.add(NodeRelationFactories.INSTANCE.create(StudioTypes.RELATION_LINK, link.getId(), link.getSource(), link.getTarget(), link.getPropertyValues()));
        }
        return actualLinks;
    }

    protected List<INodeRelation> getModelTargetConnections() {
        if (this.getModel().equals(this.getParent().getModel())) {
            return Collections.emptyList();
        }
        INodeRelation model = this.getModel();
        INodeRelation link = NodeRelationFactories.INSTANCE.create(StudioTypes.RELATION_LINK, model.getId(), model.getSource(), model.getTarget(), model.getPropertyValues());
        return Arrays.asList(link);
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        SWTUtils.getDisplay().syncExec(() -> {
            Pos position = (Pos)this.getModel().getProperty(PropertyDescriptors.DEFAULT_POSITION);
            this.getFigure().setLocation(new Point(position.x.intValue(), position.y.intValue()));
            INode status = (INode)this.getModel().getTarget().getProperty(StatusPropertyDescriptors.STATUS_OWN);
            if (((Boolean)this.getModel().getTarget().getProperty(ElementPropertyDescriptors.USE_BACKROUND_STATUS_COLOR)).booleanValue()) {
                StudioColor studioColor = (StudioColor)status.getProperty(PropertyDescriptors.COLOR);
                this.getFigure().setBackgroundColor(StudioRegistries.colorRegistry().getSWTColorFrom(studioColor));
            }
        });
    }
}

