/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.map.client.elements.bam.model.ui;

import com.centreon.studio.client.media.model.MediaRepositoryDecorator;
import com.centreon.studio.client.media.model.MediaTypes;
import com.centreon.studio.client.model.object.TypeDescriptor;
import com.centreon.studio.client.model.relation.INodeRelation;
import com.centreon.studio.client.model.repository.IRepository;
import com.centreon.studio.client.model.ui.MediaWizardPage;
import com.centreon.studio.client.model.ui.dialogs.CustomWizard;
import com.centreon.studio.client.model.ui.dialogs.CustomWizardDialog;
import com.centreon.studio.client.model.ui.dialogs.CustomWizardPage;
import com.centreon.studio.client.model.ui.dialogs.IWizardFactory;
import com.centreon.studio.map.client.elements.bam.model.BAMElementTypes;
import com.centreon.studio.map.client.elements.bam.model.ui.BaPropertiesWizardPage;
import com.centreon.studio.map.client.elements.model.ui.wizards.ElementPropertiesWizardPage;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;

public enum BAMElementWizardFactory implements IWizardFactory
{
    INSTANCE;

    private static final Set<TypeDescriptor> SUPPORTED_TYPES;

    static {
        SUPPORTED_TYPES = new HashSet<TypeDescriptor>(1);
        SUPPORTED_TYPES.add(BAMElementTypes.ELEMENT_BA);
        SUPPORTED_TYPES.add(BAMElementTypes.ELEMENT_KPI_BA);
        SUPPORTED_TYPES.add(BAMElementTypes.ELEMENT_KPI_META);
        SUPPORTED_TYPES.add(BAMElementTypes.ELEMENT_KPI_BOOLEAN);
        SUPPORTED_TYPES.add(BAMElementTypes.ELEMENT_KPI_SERVICE);
    }

    public CustomWizardDialog createDialog(INodeRelation input, IEclipseContext context) {
        MediaRepositoryDecorator mediaRepository = (MediaRepositoryDecorator)ContextInjectionFactory.make(MediaRepositoryDecorator.class, (IEclipseContext)context);
        CustomWizard wizard = null;
        if (input.getTarget().getType().equals((Object)BAMElementTypes.ELEMENT_BA)) {
            wizard = new CustomWizard("BA wizard");
            wizard.registerPage((CustomWizardPage)new BaPropertiesWizardPage());
        } else {
            wizard = new CustomWizard("KPI wizard");
            wizard.registerPage((CustomWizardPage)new ElementPropertiesWizardPage());
        }
        wizard.registerPage((CustomWizardPage)new MediaWizardPage((IRepository)mediaRepository, Arrays.asList(MediaTypes.MEDIA_IMAGE)));
        CustomWizardDialog dialog = new CustomWizardDialog(wizard);
        dialog.setInput(Arrays.asList(input));
        return dialog;
    }

    public Set<TypeDescriptor> getSupportedTypes() {
        return Collections.unmodifiableSet(SUPPORTED_TYPES);
    }
}

