/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.map.client.elements.monitoring.model;

import com.centreon.studio.client.commons.Configuration;
import com.centreon.studio.client.commons.PropertiesMapper;
import com.centreon.studio.client.cxf.AWebService;
import com.centreon.studio.client.events.BrokerEventManager;
import com.centreon.studio.client.events.StudioEvent;
import com.centreon.studio.client.events.exception.ExceptionEvent;
import com.centreon.studio.client.events.log.LogEvent;
import com.centreon.studio.client.events.popup.PopUpEvent;
import com.centreon.studio.client.model.IWebService;
import com.centreon.studio.client.model.node.INode;
import com.centreon.studio.client.model.object.TypeDescriptor;
import com.centreon.studio.client.model.property.PropertyDescriptors;
import com.centreon.studio.client.model.relation.INodeRelation;
import com.centreon.studio.map.client.elements.model.ElementPropertyDescriptors;
import com.centreon.studio.map.client.elements.monitoring.messages.MonitoringMessages;
import com.centreon.studio.map.client.resources.model.ResourceTypes;
import com.centreon.studio.map.command.CommandExecutorDto;
import com.centreon.studio.map.commandservice.CommandPortType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class MonitoringWebService
extends AWebService<CommandPortType>
implements IWebService {
    private final BrokerEventManager eventManager;

    @Inject
    public MonitoringWebService(BrokerEventManager eventManager) {
        super("/centreon-studio/services/command?wsdl", CommandPortType.class, !Configuration.SKIP_GZIP);
        this.eventManager = eventManager;
    }

    public Map<INode, Collection<INodeRelation>> create(Map<INode, Collection<INodeRelation>> nodeToRelations) {
        ArrayList<CommandExecutorDto> commands = new ArrayList<CommandExecutorDto>();
        String contextId = null;
        for (Map.Entry<INode, Collection<INodeRelation>> entry : nodeToRelations.entrySet()) {
            entry.getKey().addRelations(entry.getValue());
            for (INodeRelation relation : entry.getValue()) {
                INode element = (INode)relation.getTarget().getProperty(PropertyDescriptors.SCOPE);
                contextId = (String)element.getProperty(PropertyDescriptors.CONTEXT_ID);
                TypeDescriptor resourceType = (TypeDescriptor)element.getProperty(ElementPropertyDescriptors.RESOURCE_TYPE);
                if (resourceType != ResourceTypes.RESOURCE_SERVICE && resourceType != ResourceTypes.RESOURCE_HOST) {
                    this.eventManager.async((StudioEvent)LogEvent.error(MonitoringWebService.class, (String)"Command target resource type : {} is invalid", (Object[])new Object[]{resourceType}));
                    continue;
                }
                INode command = relation.getTarget();
                Integer commandType = command.getType().getId();
                if (resourceType == ResourceTypes.RESOURCE_SERVICE) {
                    commandType = commandType + 15;
                }
                CommandExecutorDto dto = new CommandExecutorDto();
                dto.setCommandType(commandType.intValue());
                dto.setElementId(element.getId().longValue());
                dto.getProperties().addAll(PropertiesMapper.propertiesToDtos((Collection)command.getDefaultPropertyValues()));
                dto.getProperties().addAll(PropertiesMapper.propertiesToDtos((Collection)command.getPropertyValues()));
                commands.add(dto);
            }
        }
        try {
            ((CommandPortType)this.service).execute(commands, contextId);
            this.eventManager.async((StudioEvent)new PopUpEvent().setTexts(MonitoringMessages.monitoring, MonitoringMessages.monitoringCommandsSent));
        }
        catch (Exception e) {
            this.eventManager.async((StudioEvent)new ExceptionEvent((Throwable)e));
        }
        return nodeToRelations;
    }

    public List<INodeRelation> getElementsByIds(List<Long> ids) {
        throw new UnsupportedOperationException();
    }

    public List<INodeRelation> getElementsByTypes(List<TypeDescriptor> types) {
        throw new IllegalAccessError();
    }

    public List<INodeRelation> getRelationsByIds(List<Long> ids) {
        throw new IllegalAccessError();
    }

    public boolean remove(Map<INode, Collection<INodeRelation>> nodeToRelations) {
        throw new IllegalAccessError();
    }

    public void update(Collection<INode> objects) {
        throw new IllegalAccessError();
    }

    public void updateRelation(Collection<INodeRelation> relations) {
        throw new IllegalAccessError();
    }
}

