/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.map.client.elements.monitoring.model.ui.actions;

import com.centreon.studio.client.acl.ACLUser;
import com.centreon.studio.client.model.node.INode;
import com.centreon.studio.client.model.object.TypeDescriptor;
import com.centreon.studio.client.model.properties.PropertyDescriptor;
import com.centreon.studio.client.model.relation.INodeRelation;
import com.centreon.studio.client.model.repository.IRepository;
import com.centreon.studio.client.utils.StringUtils;
import com.centreon.studio.map.client.elements.model.ElementPropertyDescriptors;
import com.centreon.studio.map.client.elements.model.ElementTypes;
import com.centreon.studio.map.client.elements.monitoring.messages.MonitoringMessages;
import com.centreon.studio.map.client.elements.monitoring.model.CentreonPropertyDescriptors;
import com.centreon.studio.map.client.elements.monitoring.model.ui.actions.ACentreonAction;
import com.centreon.studio.map.client.resources.bam.model.BAMResourceTypes;
import com.centreon.studio.map.client.resources.model.ResourcePropertyDescriptors;
import com.centreon.studio.map.client.resources.model.ResourceTypes;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class CentreonMonitoringAction
extends ACentreonAction {
    private static final Map<TypeDescriptor, PropertyDescriptor<String>> TYPE_TO_PROPERTY = new HashMap<TypeDescriptor, PropertyDescriptor<String>>();

    static {
        TYPE_TO_PROPERTY.put(ElementTypes.ELEMENT_HOST, CentreonPropertyDescriptors.URL_MONITORING_HOST);
        TYPE_TO_PROPERTY.put(ElementTypes.ELEMENT_SERVICE, CentreonPropertyDescriptors.URL_MONITORING_SERVICE);
        TYPE_TO_PROPERTY.put(ElementTypes.ELEMENT_SERVICE_META, CentreonPropertyDescriptors.URL_MONITORING_META);
        TYPE_TO_PROPERTY.put(ResourceTypes.RESOURCE_HOST, CentreonPropertyDescriptors.URL_MONITORING_HOST);
        TYPE_TO_PROPERTY.put(BAMResourceTypes.RESOURCE_BA, CentreonPropertyDescriptors.URL_MONITORING_BA);
        TYPE_TO_PROPERTY.put(ResourceTypes.RESOURCE_SERVICE, CentreonPropertyDescriptors.URL_MONITORING_SERVICE);
        TYPE_TO_PROPERTY.put(BAMResourceTypes.RESOURCE_KPI_META, CentreonPropertyDescriptors.URL_MONITORING_META);
    }

    public CentreonMonitoringAction(IRepository repository, ACLUser user) {
        super(MonitoringMessages.monitoringPage, repository, user, Collections.emptyList());
    }

    protected final String getImageDescriptorPath() {
        return ResourceTypes.RESOURCES.getSmallImage();
    }

    @Override
    protected String getSuffix(INodeRelation relation) {
        INode target = relation.getTarget();
        PropertyDescriptor<String> desc = TYPE_TO_PROPERTY.get(target.getProperty(ElementPropertyDescriptors.RESOURCE_TYPE));
        if (desc == null) {
            return null;
        }
        String url = (String)this.user.getProperty(desc);
        if (StringUtils.isNullEmptyOrBlank((String)url)) {
            return null;
        }
        long id = (Long)target.getProperty(ElementPropertyDescriptors.RESOURCE_ID);
        long actualId = target.getType() == ElementTypes.ELEMENT_SERVICE ? id & 0xFFFFL : id;
        return url.replaceAll(ACentreonAction.macro(ResourcePropertyDescriptors.RESOURCE_NAME), (String)target.getProperty(ResourcePropertyDescriptors.RESOURCE_NAME)).replaceAll(ACentreonAction.macro(ResourcePropertyDescriptors.PARENT_RESOURCE_NAME), (String)target.getProperty(ResourcePropertyDescriptors.PARENT_RESOURCE_NAME)).replaceAll(ACentreonAction.macro(ElementPropertyDescriptors.RESOURCE_ID), String.valueOf(actualId));
    }
}

