/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.map.client.elements.monitoring.model.ui.actions;

import com.centreon.studio.client.model.node.INode;
import com.centreon.studio.client.model.node.INodeUtils;
import com.centreon.studio.client.model.object.TypeDescriptor;
import com.centreon.studio.client.model.properties.PropertyValue;
import com.centreon.studio.client.model.relation.INodeRelation;
import com.centreon.studio.client.model.relation.NodeRelationFactories;
import com.centreon.studio.client.model.repository.IRepository;
import com.centreon.studio.map.client.elements.model.ElementTypes;
import com.centreon.studio.map.client.elements.monitoring.messages.MonitoringMessages;
import com.centreon.studio.map.client.elements.monitoring.model.MonitoringTypes;
import com.centreon.studio.map.client.elements.monitoring.model.ui.actions.AMonitoringAction;
import com.centreon.studio.map.client.status.model.StatusPropertyDescriptors;
import com.centreon.studio.map.client.status.model.StatusTypes;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.e4.core.contexts.IEclipseContext;

public class RemoveDowntimeAction
extends AMonitoringAction {
    private static boolean contains(INode downtime, List<INodeRelation> commands) {
        for (INodeRelation command : commands) {
            for (INodeRelation downtimeRelations : command.getTarget().getRelations(new TypeDescriptor[]{StatusTypes.DOWNTIME})) {
                if (!downtime.equals((Object)downtimeRelations.getTarget())) continue;
                return true;
            }
        }
        return false;
    }

    private static INode findDowntime(INode element, INode downtime) {
        for (INodeRelation downtimeRelation : element.getRelations(new TypeDescriptor[]{StatusTypes.DOWNTIME})) {
            if (!downtimeRelation.getTarget().equals((Object)downtime)) continue;
            return downtimeRelation.getTarget();
        }
        return null;
    }

    public RemoveDowntimeAction(IRepository input, IRepository commandRepositoryDecorator, IEclipseContext context) {
        super(MonitoringMessages.removeDowntimeAdd, input, commandRepositoryDecorator, context);
    }

    @Override
    protected void addToRepository(List<INodeRelation> commandRelations) {
        ArrayList<INodeRelation> actualRelations = new ArrayList<INodeRelation>(commandRelations.size());
        for (INodeRelation commandRelation : commandRelations) {
            List downtimeRelations = commandRelation.getTarget().getRelations(new TypeDescriptor[]{StatusTypes.DOWNTIME});
            for (INodeRelation downtimeRelation : downtimeRelations) {
                INode actualCommand = INodeUtils.copy((INode)commandRelation.getTarget(), (boolean)false, (boolean)false, (IRepository)this.commandRepository, (PropertyValue[])new PropertyValue[0]);
                INode actualDowntime = RemoveDowntimeAction.findDowntime(commandRelation.getSource(), downtimeRelation.getTarget());
                if (actualDowntime == null) continue;
                actualCommand.addPropertyValue(StatusPropertyDescriptors.DOWNTIME_ID, (Object)((Long)actualDowntime.getProperty(StatusPropertyDescriptors.DOWNTIME_ID)));
                actualRelations.add(NodeRelationFactories.INSTANCE.create(commandRelation.getSource(), actualCommand));
            }
        }
        super.addToRepository(actualRelations);
    }

    @Override
    protected void createRecursiveCommands(INode source, INodeRelation commandRelation, List<INodeRelation> commands) {
        for (INodeRelation relation : source.getRelations(new TypeDescriptor[]{ElementTypes.RELATION_HIERARCHY, ElementTypes.RELATION_HIERARCHY_GRAPHIC})) {
            INode copiedCommand = INodeUtils.copy((INode)commandRelation.getTarget(), (boolean)false, (boolean)false, (IRepository)this.commandRepository, (PropertyValue[])new PropertyValue[0]);
            INodeRelation copiedRelation = NodeRelationFactories.INSTANCE.create(relation.getTarget(), copiedCommand);
            commands.add(copiedRelation);
            for (INodeRelation downtimeRelation : relation.getTarget().getRelations(new TypeDescriptor[]{StatusTypes.DOWNTIME})) {
                if (!RemoveDowntimeAction.contains(downtimeRelation.getTarget(), commands)) continue;
                INode copiedDowntime = INodeUtils.copy((INode)downtimeRelation.getTarget(), (boolean)true, (boolean)true, (IRepository)downtimeRelation.getTarget().getRepository(), (PropertyValue[])new PropertyValue[0]);
                copiedCommand.addRelation(NodeRelationFactories.INSTANCE.create(copiedCommand, copiedDowntime));
            }
            this.createRecursiveCommands(relation.getTarget(), commandRelation, commands);
        }
    }

    protected String getImageDescriptorPath() {
        return "platform:/plugin/com.centreon.studio.map.client.elements/img/flags/downtime-16.png";
    }

    @Override
    protected TypeDescriptor getType() {
        return MonitoringTypes.COMMAND_REMOVE_DOWNTIME;
    }

    @Override
    protected Boolean isFlagged(INode target) {
        return !target.getRelations(new TypeDescriptor[]{StatusTypes.DOWNTIME}).isEmpty();
    }
}

