/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.map.client.elements.monitoring.model.ui.dialogs;

import com.centreon.studio.client.commons.jface.validation.ControlValidators;
import com.centreon.studio.client.commons.jface.validation.field.impl.TextField;
import com.centreon.studio.client.commons.swt.SWTUtils;
import com.centreon.studio.client.model.object.IObject;
import com.centreon.studio.client.model.object.TypeDescriptor;
import com.centreon.studio.client.model.ui.dialogs.CustomWizardPage;
import com.centreon.studio.map.client.elements.model.ElementPropertyDescriptors;
import com.centreon.studio.map.client.elements.model.ElementTypes;
import com.centreon.studio.map.client.elements.monitoring.messages.MonitoringMessages;
import com.centreon.studio.map.client.elements.monitoring.model.MonitoringPropertyDescriptors;
import com.centreon.studio.map.client.elements.monitoring.model.ui.dialogs.AddAcknowledgementWizardPage;
import com.centreon.studio.map.client.resources.model.ResourceTypes;
import com.centreon.studio.map.client.status.model.StatusPropertyDescriptors;
import java.util.Arrays;
import java.util.Collection;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public abstract class AMonitoringWizardPage
extends CustomWizardPage {
    private static final Collection<TypeDescriptor> RECURSIVE_RESOURCES = Arrays.asList(ResourceTypes.RESOURCE_SERVICE_GROUP, ResourceTypes.RESOURCE_HOST_GROUP, ResourceTypes.RESOURCE_HOST);
    private static final Collection<TypeDescriptor> RECURSIVE_ELEMENTS = Arrays.asList(ElementTypes.ELEMENT_CONTAINER, ElementTypes.ELEMENT_GROUP);
    private final String commentLabel;
    private final boolean displayComment;
    private Button recursive;

    protected AMonitoringWizardPage(String pageName, String commentLabel, boolean displayComment) {
        super(pageName);
        this.displayComment = displayComment;
        this.commentLabel = commentLabel;
    }

    public final Composite customCreateControl(Composite parent) {
        Composite composite = SWTUtils.createComposite((Composite)parent, (int)1, (boolean)true, (int)0, (int)0);
        this.createCustom(composite);
        this.createFooter(composite);
        this.setControl((Control)composite);
        return composite;
    }

    public Point getPageSize() {
        return new Point(300, 300);
    }

    protected void createCustom(Composite parent) {
    }

    protected boolean performFinish() {
        return true;
    }

    private void createFooter(Composite parent) {
        Composite compositeComments = SWTUtils.createComposite((Composite)parent, (int)1, (boolean)false, (int)0, (int)-5, (GridData)new GridData(4, 4, true, false, 1, 1));
        if (this.displayComment) {
            SWTUtils.createLabel((Composite)compositeComments, (String)MonitoringMessages.comment, (int)1, (int)0x1000000, (int)-1, (int)-1);
            Text commentText = SWTUtils.createText((Composite)compositeComments, (int)2626, (int)80, (int)-1);
            commentText.setLayoutData((Object)SWTUtils.createGridData((int)4, (int)4, (int)-1, (int)80));
            final TextField comment = new TextField(commentText, "", this.commentLabel, this.getForm(), ControlValidators.TEXT_NON_EMPTY_VALIDATOR);
            ((Text)comment.getControl()).addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    AMonitoringWizardPage.this.getInput().getTarget().addPropertyValue(StatusPropertyDescriptors.COMMENTS, (Object)comment.getValue());
                }
            });
        }
        TypeDescriptor resourceType = (TypeDescriptor)this.getInput().getSource().getProperty(ElementPropertyDescriptors.RESOURCE_TYPE);
        TypeDescriptor elementType = this.getInput().getSource().getType();
        if (RECURSIVE_ELEMENTS.contains(elementType) || RECURSIVE_RESOURCES.contains(resourceType)) {
            Composite recursiveComposite = SWTUtils.createComposite((Composite)parent, (int)1, (boolean)false, (int)0, (int)5, (GridData)new GridData(1, 0x1000000, false, false, 1, 1));
            this.recursive = SWTUtils.createButtonCheck((Composite)recursiveComposite, (String)MonitoringMessages.recursivity);
            this.recursive.setSelection(((Boolean)this.getInput().getTarget().getProperty(MonitoringPropertyDescriptors.RECURSIVE)).booleanValue());
            this.recursive.addSelectionListener((SelectionListener)new AddAcknowledgementWizardPage.SetPropertyValueSelectionAdapter(this.recursive, MonitoringPropertyDescriptors.RECURSIVE, (IObject)this.getInput().getTarget()));
        }
    }
}

