/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.map.client.elements.monitoring.model.ui.dialogs;

import com.centreon.studio.client.commons.swt.SWTUtils;
import com.centreon.studio.client.utils.StringUtils;
import com.centreon.studio.map.client.elements.monitoring.messages.MonitoringMessages;
import com.centreon.studio.map.client.elements.monitoring.model.ui.dialogs.AMonitoringWizardPage;
import com.centreon.studio.map.client.status.model.StatusPropertyDescriptors;
import com.centreon.studio.map.client.status.model.UnixDate;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Group;

public class AddDowntimeWizardPage
extends AMonitoringWizardPage {
    private static final Integer[] DAYS = new Integer[]{0, 1, 2, 3, 4, 5, 6, 7};
    private static final Integer[] HOURS = new Integer[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23};
    private static final Integer[] MINUTES = new Integer[]{0, 5, 10, 15, 20, 25, 30, 35, 40, 45, 50, 55};
    private DateTime endDate;
    private DateTime endTime;
    private DateTime startTime;
    private DateTime startDate;
    private Button flexibleCheck;
    private Combo flexibleDays;
    private Combo flexibleHours;
    private final GregorianCalendar startCalendar = new GregorianCalendar();
    private final GregorianCalendar endCalendar = new GregorianCalendar();
    private Combo flexibleMinutes;

    private static void update(DateTime dateTime, Calendar calendar) {
        dateTime.setDate(calendar.get(1), calendar.get(2), calendar.get(5));
        dateTime.setTime(calendar.get(11), calendar.get(12), calendar.get(13));
    }

    protected AddDowntimeWizardPage() {
        super(AddDowntimeWizardPage.class.getSimpleName(), MonitoringMessages.downtimeSetBy, true);
        this.setTitle(MonitoringMessages.downtimeTitle);
        this.setDescription(MonitoringMessages.downtimeDescription);
        this.startCalendar.setTime(new Date());
        this.endCalendar.setTime(new Date(System.currentTimeMillis() + 3600000L));
    }

    @Override
    public Point getPageSize() {
        return new Point(600, 300);
    }

    @Override
    protected void createCustom(Composite parent) {
        Group group = SWTUtils.createGroup((Composite)parent, (String)MonitoringMessages.downtimeSetTime, (int)5, (int)4, (boolean)false, (GridData)new GridData(4, 0x1000000, true, false, 1, 1));
        SelectionAdapter startListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (AddDowntimeWizardPage.this.endCalendar.before(AddDowntimeWizardPage.this.startCalendar)) {
                    AddDowntimeWizardPage.this.endCalendar.setTime(AddDowntimeWizardPage.this.startCalendar.getTime());
                    AddDowntimeWizardPage.this.endCalendar.set(11, AddDowntimeWizardPage.this.startCalendar.get(11) + 1);
                    AddDowntimeWizardPage.update(AddDowntimeWizardPage.this.endDate, AddDowntimeWizardPage.this.endCalendar);
                    AddDowntimeWizardPage.update(AddDowntimeWizardPage.this.endTime, AddDowntimeWizardPage.this.endCalendar);
                }
            }
        };
        this.startDate = SWTUtils.createDateTime((Composite)group, (String)MonitoringMessages.downtimeStartDate, (Calendar)this.startCalendar, (int)32, (SelectionListener)startListener);
        this.startTime = SWTUtils.createDateTime((Composite)group, (String)MonitoringMessages.downtimeStartTime, (Calendar)this.startCalendar, (int)128, (SelectionListener)startListener);
        SelectionAdapter endListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (AddDowntimeWizardPage.this.startCalendar.after(AddDowntimeWizardPage.this.endCalendar)) {
                    AddDowntimeWizardPage.this.startCalendar.setTime(AddDowntimeWizardPage.this.endCalendar.getTime());
                    AddDowntimeWizardPage.this.startCalendar.set(11, AddDowntimeWizardPage.this.endCalendar.get(11) - 1);
                    AddDowntimeWizardPage.update(AddDowntimeWizardPage.this.startDate, AddDowntimeWizardPage.this.startCalendar);
                    AddDowntimeWizardPage.update(AddDowntimeWizardPage.this.startTime, AddDowntimeWizardPage.this.startCalendar);
                }
            }
        };
        this.endDate = SWTUtils.createDateTime((Composite)group, (String)MonitoringMessages.downtimeEndDate, (Calendar)this.endCalendar, (int)32, (SelectionListener)endListener);
        this.endTime = SWTUtils.createDateTime((Composite)group, (String)MonitoringMessages.downtimeEndTime, (Calendar)this.endCalendar, (int)128, (SelectionListener)endListener);
        Group flexibleGroup = SWTUtils.createGroup((Composite)parent, (String)MonitoringMessages.downtimeFlexible, (int)5, (int)6, (boolean)false, (GridData)new GridData(4, 0x1000000, true, false, 1, 1));
        this.flexibleCheck = SWTUtils.createButtonCheck((Composite)flexibleGroup, (String)MonitoringMessages.downtimeFixed);
        this.flexibleCheck.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.flexibleCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AddDowntimeWizardPage.this.flexibleDays.setEnabled(AddDowntimeWizardPage.this.flexibleCheck.getSelection());
                AddDowntimeWizardPage.this.flexibleHours.setEnabled(AddDowntimeWizardPage.this.flexibleCheck.getSelection());
                AddDowntimeWizardPage.this.flexibleMinutes.setEnabled(AddDowntimeWizardPage.this.flexibleCheck.getSelection());
            }
        });
        SWTUtils.createSpanner((Composite)flexibleGroup, (int)4, (int)1);
        SWTUtils.createLabel((Composite)flexibleGroup, (String)MonitoringMessages.days, (int)1, (int)0x1000000, (int)100, (int)-1);
        this.flexibleDays = SWTUtils.createCombo((Composite)flexibleGroup, (int)8, (Object[])DAYS, (GridData)SWTUtils.createGridData((int)4, (int)0x1000000, (int)-1, (int)-1), null);
        this.flexibleDays.setEnabled(false);
        this.flexibleDays.select(0);
        SWTUtils.createLabel((Composite)flexibleGroup, (String)MonitoringMessages.hours, (int)1, (int)0x1000000, (int)100, (int)-1);
        this.flexibleHours = SWTUtils.createCombo((Composite)flexibleGroup, (int)8, (Object[])HOURS, (GridData)SWTUtils.createGridData((int)4, (int)0x1000000, (int)-1, (int)-1), null);
        this.flexibleHours.setEnabled(false);
        this.flexibleHours.select(0);
        SWTUtils.createLabel((Composite)flexibleGroup, (String)MonitoringMessages.minutes, (int)1, (int)0x1000000, (int)100, (int)-1);
        this.flexibleMinutes = SWTUtils.createCombo((Composite)flexibleGroup, (int)8, (Object[])MINUTES, (GridData)SWTUtils.createGridData((int)4, (int)0x1000000, (int)-1, (int)-1), null);
        this.flexibleMinutes.setEnabled(false);
        this.flexibleMinutes.select(0);
    }

    @Override
    protected boolean performFinish() {
        this.getInput().getTarget().addPropertyValue(StatusPropertyDescriptors.ENDDATE, (Object)new UnixDate(this.endCalendar.getTimeInMillis()));
        this.getInput().getTarget().addPropertyValue(StatusPropertyDescriptors.STARTDATE, (Object)new UnixDate(this.startCalendar.getTimeInMillis()));
        if (this.flexibleCheck.getSelection()) {
            long duration = Math.max(0L, StringUtils.parseLong((String)this.flexibleDays.getText(), (long)0L)) * 1000L * 60L * 60L * 24L;
            duration += Math.max(0L, StringUtils.parseLong((String)this.flexibleHours.getText(), (long)0L)) * 1000L * 60L * 60L;
            this.getInput().getTarget().addPropertyValue(StatusPropertyDescriptors.FLEXIBLE_DURATION, (Object)(duration += Math.max(0L, StringUtils.parseLong((String)this.flexibleMinutes.getText(), (long)0L)) * 1000L * 60L));
            this.getInput().getTarget().addPropertyValue(StatusPropertyDescriptors.FLEXIBLE, (Object)Boolean.TRUE);
        } else {
            this.getInput().getTarget().addPropertyValue(StatusPropertyDescriptors.FLEXIBLE_DURATION, null);
            this.getInput().getTarget().addPropertyValue(StatusPropertyDescriptors.FLEXIBLE, null);
        }
        return super.performFinish();
    }
}

