/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.map.client.elements.monitoring.model.ui.dialogs;

import com.centreon.studio.client.commons.swt.SWTUtils;
import com.centreon.studio.client.model.node.INode;
import com.centreon.studio.client.model.node.INodeUtils;
import com.centreon.studio.client.model.object.IObject;
import com.centreon.studio.client.model.object.TypeDescriptor;
import com.centreon.studio.client.model.properties.PropertyFormatter;
import com.centreon.studio.client.model.properties.PropertyValue;
import com.centreon.studio.client.model.relation.INodeRelation;
import com.centreon.studio.client.model.relation.NodeRelationFactories;
import com.centreon.studio.client.model.repository.IRepository;
import com.centreon.studio.map.client.elements.model.ElementTypes;
import com.centreon.studio.map.client.elements.monitoring.messages.MonitoringMessages;
import com.centreon.studio.map.client.elements.monitoring.model.MonitoringPropertyDescriptors;
import com.centreon.studio.map.client.elements.monitoring.model.ui.dialogs.AMonitoringWizardPage;
import com.centreon.studio.map.client.status.message.StatusMessages;
import com.centreon.studio.map.client.status.model.StatusPropertyDescriptors;
import com.centreon.studio.map.client.status.model.StatusTypes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class RemoveDowntimeWizardPage
extends AMonitoringWizardPage {
    private final Collection<Button> buttons = new ArrayList<Button>();
    private int selected;
    private Composite composite;
    private final Collection<INode> selectedDowntimes = new ArrayList<INode>(5);

    protected RemoveDowntimeWizardPage() {
        super(RemoveDowntimeWizardPage.class.getSimpleName(), MonitoringMessages.removeDowntimeTextMessage, false);
        this.setDescription(MonitoringMessages.removeDowntimeDescription);
        this.setTitle(MonitoringMessages.removeDowntimeTitle);
    }

    @Override
    public Point getPageSize() {
        return new Point(600, 150);
    }

    public boolean isPageComplete() {
        return super.isPageComplete() && this.selected > 0;
    }

    public final void propertiesChanged(IObject object, Collection<PropertyValue> propertyValues) {
        super.propertiesChanged(object, propertyValues);
        for (PropertyValue pv : propertyValues) {
            if (pv.getProperty() != MonitoringPropertyDescriptors.RECURSIVE) continue;
            this.selectedDowntimes.clear();
            for (Button button : this.buttons) {
                if (!button.getSelection()) continue;
                this.selectedDowntimes.add((INode)button.getData());
            }
            this.createButtons();
            return;
        }
    }

    @Override
    protected void createCustom(Composite parent) {
        ScrolledComposite scrollComposite = new ScrolledComposite(parent, 2562);
        scrollComposite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.composite = SWTUtils.createComposite((Composite)scrollComposite, (int)1, (boolean)true, (int)5, (int)5);
        scrollComposite.setMinSize(this.composite.computeSize(-1, -1));
        scrollComposite.setContent((Control)this.composite);
        scrollComposite.setExpandHorizontal(true);
        scrollComposite.setExpandVertical(true);
        this.createButtons();
    }

    @Override
    protected boolean performFinish() {
        INode command = this.getInput().getTarget();
        for (Button button : this.buttons) {
            if (!button.getSelection()) continue;
            INode downtime = (INode)button.getData();
            INode copiedDowntime = INodeUtils.copy((INode)downtime, (boolean)true, (boolean)true, (IRepository)downtime.getRepository(), (PropertyValue[])new PropertyValue[0]);
            command.addRelation(NodeRelationFactories.INSTANCE.create(command, copiedDowntime));
        }
        return super.performFinish();
    }

    private void createButtons() {
        for (Button button : this.buttons) {
            button.dispose();
        }
        this.buttons.clear();
        HashSet<INode> downtimes = new HashSet<INode>();
        for (INodeRelation selection : this.getInput().getSource().getRepository().getSelections()) {
            this.findDowntimes(selection.getTarget(), downtimes, (Boolean)this.getInput().getTarget().getProperty(MonitoringPropertyDescriptors.RECURSIVE));
        }
        PropertyFormatter formater = PropertyFormatter.getPropetyFormatter(Date.class);
        for (INode downtime : downtimes) {
            StringBuilder builder = new StringBuilder();
            builder.append(StatusMessages.from);
            builder.append(" ");
            builder.append(formater.toString((Object)((Date)downtime.getProperty(StatusPropertyDescriptors.STARTDATE))));
            builder.append(" ");
            builder.append(StatusMessages.to);
            builder.append(" ");
            builder.append(formater.toString((Object)((Date)downtime.getProperty(StatusPropertyDescriptors.ENDDATE))));
            final Button button = SWTUtils.createButtonCheck((Composite)this.composite, (String)builder.toString());
            button.setData((Object)downtime);
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (button.getSelection()) {
                        RemoveDowntimeWizardPage removeDowntimeWizardPage = RemoveDowntimeWizardPage.this;
                        removeDowntimeWizardPage.selected = removeDowntimeWizardPage.selected + 1;
                    } else {
                        RemoveDowntimeWizardPage removeDowntimeWizardPage = RemoveDowntimeWizardPage.this;
                        removeDowntimeWizardPage.selected = removeDowntimeWizardPage.selected - 1;
                    }
                    RemoveDowntimeWizardPage.this.getWizard().getContainer().updateButtons();
                }
            });
            if (this.selectedDowntimes.contains(downtime)) {
                button.setSelection(true);
            }
            this.buttons.add(button);
        }
        this.composite.layout();
    }

    private void findDowntimes(INode target, Set<INode> downtimes, boolean recursive) {
        for (INodeRelation targetDowntimeRelation : target.getRelations(new TypeDescriptor[]{StatusTypes.DOWNTIME})) {
            downtimes.add(targetDowntimeRelation.getTarget());
        }
        if (recursive) {
            for (INodeRelation targetRelation : target.getRelations(new TypeDescriptor[]{ElementTypes.RELATION_HIERARCHY, ElementTypes.RELATION_HIERARCHY_GRAPHIC})) {
                this.findDowntimes(targetRelation.getTarget(), downtimes, recursive);
            }
        }
    }
}

